@extends('layouts.front')

@section('content')

<style>
  .action-icon {
    padding-top: 3px;
  }

  @media only screen and (min-width: 1200px) {
    #leukeVideos1 .video-container {
      height: 275px;
      margin-bottom: 0;
    }
  }

  #leukeVideos1 .video-container {
    position: relative;
    width: 100%;
    height: 300px;
    /* or any fixed height you want */
    overflow: hidden;
    border-radius: 2px;
  }

  #leukeVideos1 .video-container video {
    width: 100%;
    height: 100%;
    object-fit: cover;
    display: block;
    background-color: #000;
    border-radius: 2px;
  }

  #leukeVideos1 {
    grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
    display: grid;
    gap: 8px;
  }

  #delete-btn {
    display: none;
  }

  #delete-btn-m {
    display: none;
  }

  .checkboxCont {
    position: absolute;
    top: 10px;
    left: 10px;
    z-index: 999;
  }

  #delete-btn {
    width: auto;
    padding: 8px;
    margin-bottom: 16px;
  }
</style>

<!-- include('includes.topbar') -->

<section class="pt-4 vh-94">
  <div class="container-fluid">
    <div class="row align-items-center">
      <div class="col-xl-2 col-lg-2 col-md-2">
        @include('includes.leftSidebar')
      </div>

      <div class="col-xl-10 col-lg-10 col-md-10 m-auto">
        <div class="right-container m-auto">
          <div class="container-fluid">
            <div class="row user_profile_top">
              <div class="col-xl-2 col-lg-3 col-md-3 col-4">
                <a href="{{ route('web.userProfile',$userInfo->user_id) }}">
                  <?php if (!empty($userInfo->user_dp)) {
                    if (strpos($userInfo->user_dp, 'fbsbx.com') !== false || strpos($userInfo->user_dp, 'googleusercontent.com') !== false || strpos($userInfo->user_dp, 'facebook.com') !== false) {
                      $user_dp = $userInfo->user_dp;
                    } else {
                      $user_dp = asset(Storage::url('public/profile_pic/' . $userInfo->user_id) . '/small/' . $userInfo->user_dp);
                    }
                  } else {
                    $user_dp = asset('default/default.png');
                  } ?>
                  <img class="rounded-circle img-responsive" src="{{ $user_dp }}" alt="" />
                </a>
              </div>
              <div class="col-xl-10 col-lg-9 col-md-9 col-8 pt-2 ">
                <div class="row">
                  <div class="col-md-12 p-0 ">
                    <a href="{{ route('web.userProfile',$userInfo->user_id) }}">
                      <h4 style="text-transform: capitalize;cursor:pointer">{{ $userInfo->fname }} {{ $userInfo->lname }}</h4>
                    </a>
                  </div>
                  <a href="{{ route('web.userProfile',$userInfo->user_id) }}">
                    <h5 class="col-lg-8 col-md-8 p-0" >{{ '@'.$userInfo->username }} <?php if ($userInfo->verified == 'A') { ?>
                        <img src="{{ asset('default/verified-icon-blue.png') }}" alt="" style="width:15px;height:15px;">
                      <?php } ?>
                    </h5>
                  </a>
                </div>
                <div class="row mb-3">
                  <div class="col-md-12 col-12 p-0 pt-1 userProfileLinks">
                    <span class="pl-1 pr-1 "><a href="{{ route('web.userProfile',$userInfo->user_id) }}"><strong>{{ !empty($userInfo->total_videos) ? $userInfo->total_videos : '0' }}</strong> videos</a></span>
                    <span class="pl-1 pr-1 text-center"><strong>{{ !empty($userInfo->total_likes) ? $userInfo->total_likes : '0' }}</strong> likes</span>
                    <span class=" pl-1 pr-1  text-center"><a href="{{ route('web.followers-list',$userInfo->user_id)}}"><strong>{{ $followers }}</strong> followers</a></span>
                    <span class="pl-1 pr-1  text-right"><a href="{{ route('web.following-list',$userInfo->user_id)}}"><strong>{{ $following }}</strong> following</a></span>
                  </div>
                </div>
                <!-- </div> -->
                <div class="row mb-3">
                  <div class="col-md-12 col-12 pt-1 p-0 ">
                    @if (auth()->guard('web')->check())
                    @if (auth()->guard('web')->user()->user_id == $userInfo->user_id)
                    <a class="btn col-md-3 small d-inline" href="{{ route('web.editUserProfile', $userInfo->user_id) }}" style="padding:8px">
                      <!-- <i class="fa fa-edit"></i> --> Edit Profile
                    </a>
                    @endif
                    @endif

                    @if(!$blocked)
                    <div class="p-0 pr-2 small d-inline">

                      @if ($canFollow && $blockedTo==false)
                      <a class="btn col-md-3 small d-inline" onclick="followUnfollow('{{ $userInfo->user_id }}')" style="padding:8px;">
                        <!-- <span id="followUnfollowIcon">
                                              <?php if (!$followed) { ?>
                                              <i class="fa fa-user-plus"></i>
                                              <?php } else { ?>
                                                  <i class="fa fa-user-times"></i>
                                              <?php } ?>
                                            </span> -->
                        <span id="followUnfollow">
                          @if(!$followed) Follow @else Unfollow @endif</span>
                      </a>
                      @endif
                    </div>
                    @endif
                    @if (auth()->guard('web')->check())
                    @if (auth()->guard('web')->user()->user_id != $userInfo->user_id && $blockedTo==false)
                    <div class="p-0 pr-2 small d-inline">
                      <a onclick="blockUnblock('{{ $userInfo->user_id }}')" class="btn col-md-3 d-inline" style="padding:8px;">
                        <!-- <span id="blockUnblockIcon">
                                          <?php if (!$blocked) { ?>
                                              <i class="fa fa-ban"></i>
                                          <?php } else { ?>
                                              <i class="fa fa-check-circle"></i>
                                          <?php } ?>        
                                        </span> -->
                        <span id="blockUnblock">
                          @if(!$blocked) Block @else Unblock @endif
                        </span>
                      </a>
                    </div>
                    @endif
                    @endif
                  </div>
                </div>
              </div>
            </div>
            <hr>
            <div class="row">
              @if ($videos->count() > 0 && !$blocked && $blockedTo==false)
              <div class="col-lg-7 col-8 col-sm-12">
                <!-- <h2>Videos</h2> -->
                <div class="alert alert-success " style="display:none;">Video Delete Successfully</div>
              </div>
              <div class="col-lg-5 col-4 text-right pr-2">
                @if (auth()->guard('web')->check())
                @if (auth()->guard('web')->user()->user_id == $userInfo->user_id)

                <a class=" btn " id="delete-btn" onclick="deleteVideo()" style12="{{MyFunctions::getTopbarColor()}}"><i class="fa fa-trash"></i> Delete Selected</a>
                <a class=" d-lg-none m_select_delete " id="delete-btn-m" onclick="deleteVideo()"><i class="fa fa-trash"></i></a>

                <!-- <a class="d-none d-lg-inline-block btn btn-blue bg-btn text-white" onclick="deleteVideo()" style="{{MyFunctions::getTopbarColor()}}"><i class="fa fa-trash"></i> Delete Selected</a>
                                    <a class="d-block d-lg-none m_select_delete" onclick="deleteVideo()"><i class="fa fa-trash"></i></a> -->

                @endif
                @endif
              </div>
              @else
              <h3>No Videos Found</h3>
              @endif
            </div>
            <div class="row">

              <div class="col-lg-12  col-sm-12 mb-5">
                <div class="row" id="leukeVideos1">
                  @php
                  $count=0;
                  $x = 1;
                  @endphp
                  @if(!$blocked && $blockedTo==false)
                  @foreach ($videos as $video)
                  @include("partials.userVideo")

                  @php
                  $count++;
                  $x++;
                  @endphp
                  @endforeach
                  @endif
                </div>
                <div class="loadMore text-center col-12">
                  <img src="{{ asset('default/loading.gif') }}" style="width:35px;margin-top:10px;">
                </div>
              </div>

            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  @include('partials.leukeModal')
</section>

@include('includes.modalVideoJs')
<script type="text/javascript">
  $(document).click('input:checkbox', function() {
    // $('input:checkbox').on('click',function(){
    if ($('input[name="chk[]"]:checked').length > 0) {
      $('#delete-btn').css({
        'display': 'block'
      });
    } else {
      $('#delete-btn').hide({
        'display': 'none'
      });
    }
  });
  // });


  function deleteVideo() {
    var video_ids = [];
    var videoFetchUrl = "{{route('web.userProfile',['id'=> $userInfo->user_id])}}";
    $('input:checkbox').filter(':checked').each(function() {
      video_ids.push($(this).val());
    });

    $.ajax({
      type: "POST",
      url: "{{ route('web.deleteVideo') }}",
      data: {
        '_token': "{{ csrf_token() }}",
        'videos': video_ids,
      },
      dataType: "json",
      success: function(response) {

        $.ajax({
          type: "GET",
          url: videoFetchUrl,
          data: {
            page: page,
            delete: 'yes'
          },
          dataType: "json",
          success: function(response) {

            if (response.html != '') {
              // page = x;
              totalVideo = response.videosCount;
              loadedVideo = loadedVideo + response.videos.length;
              // alert(response.videos.data.length);
              $('.loadMore').hide();

              $('#leukeVideos').html(response.html);

            }
          }
        });

        $('.alert-success').fadeIn(600, function() {
          $(this).delay(4000).fadeOut(600);
        });
        // checkbox_
        // $('.alert-success').show();
        // setTimeout(() => {
        //   location.reload();
        // }, 2000);

      }
    });

  }
</script>

@endsection