@extends('layouts.front')

@section('content')
<style>
	.upload-icon {
		font-size: 54px;
		text-align: center;
		color: #7950c2;
		margin-top: 20px;
	}

	/* .dz-message{
	color: #eb4a64;
    margin: 0;
    margin-bottom: 40px;
	
} */
	footer,
	.footer {
		position: absolute;
		overflow: hidden;
		background-color: #e1effa;
		font-size: 16px;
		bottom: 0px;
		font-weight: 400;
		color: #8b9aa8;
		width: 100%;
	}

	.dz-message {
		color: #b3b3b3;
		font-size: 24px !important;
	}

	.dropzone {
		min-height: 150px;
		border: 0px !important;
		border-radius: 15px;
		padding: 20px 20px;
	}

	.drag-drop {
		font-size: 16px !important;
	}
</style>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.4.0/min/dropzone.min.css">
<!-- include('includes.topbar') -->
<section class="pt-4 vh-94">
	<div class="container-fluid">
		<div class="row align-items-center">


			<div class="col-xl-2 col-lg-2 col-md-12">
				@include('includes.leftSidebar')
			</div>

			<div class="col-xl-9 col-lg-9 col-md-12 offset-xl-3 offset-lg-1 offset-md-1 m-auto">
        <div class="right-container m-auto">
					<h4>Upload Videos</h4>
					<hr />
					<div>
						@if ($message = Session::get('error'))
						<div class="alert alert-danger background-danger">
							<button type="button" class="close" data-bs-dismiss="alert">×</button>
							<strong>{{ $message }}</strong>
						</div>
						@endif

						<!--<form method="post" action="{{ route('web.insertVideo') }}" enctype="multipart/form-data"-->
						<!--			class="dropzone text-center" id="dropzone">-->
						<!--	@csrf-->
						<!--	<div class="dz-message" data-dz-message><span>-->
						<!--	<div class="upload-icon">-->
						<!--		<i class="fa fa-cloud-upload" aria-hidden="true"></i></div><br />	-->
						<!--		Drop or Select file to upload</span>-->
						<!--	</div>-->

						<!--</form>-->

						<form method="post" action="{{ route('web.insertVideo') }}" enctype="multipart/form-data"
							class="dropzone text-center" id="dropzone">
							@csrf
							<div class="dz-message" data-dz-message><span>
									<div class="upload-icon">
										<img src="{{ asset('assets/images/upload_icon.png') }}" />
										<!-- <i class="fa fa-cloud-upload" aria-hidden="true"></i> -->
									</div>
									<br />
									Select video to upload
								</span><br />
								<span class="drag-drop">Or drag and drop a file</span>
							</div>

						</form>
						<br />
						<div class="col-md-12 alert alert-success" style="display:none;">Video Upload successfully</div>
						<div class="col-md-12 alert alert-error alert-danger" style="display:none;"></div>
					</div>
				</div>

			</div>
		</div>

	</div>
	</div>
	</div>
	</div>
	</div>

</section><!-- about -->

<script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.4.0/dropzone.js"></script>
<script>
	$(function() {
		Dropzone.options.dropzone = {
			maxFilesize: 209715200,
			acceptedFiles: "video/*",
			addRemoveLinks: true,
			timeout: 1800000,
			maxFiles: 1,
			error: function(file, response) {
				file.previewElement.classList.add("dz-error");
			},
			success: function(file, response) {
				console.log(response);
				if (response.status == "success") {
					var id = response.v_id;
					$(".alert-success").show();

					var url = '{{ route("web.video-info-update", ":id") }}';
					url = url.replace(':id', id);

					window.location = url;
				} else {
					$(".alert-error").show();
					$(".alert-error").text(response.msg);
					setTimeout(function() {
						//   $(".alert-error").hide();
						window.location.reload();
					}, 10000);
				}
			}
		};
	});
</script>
@endsection