@extends('layouts.front')

@section('content')
<style>
	.bg-btn {
		/* background: linear-gradient(50deg, rgb(115,80,199) 0%, rgb(236,74,99) 100%); */

		padding: 10px 0;
		color: #fff;
		border-radius: 2px;
	}

	#myTab li {
		text-align: center;
		font-size: 20px;

	}

	#myTab li a.active {
		color: #000;
	}

	#myTab li a {
		padding: 12px;
		color: #c8cdcd;
		padding: 8px;
		font-size: 16px;
	}

	/* .nav-item .active{
		color: "{{MyFunctions::getTopbarColor()}}";
	
	} */
	.tag {
		border: 1px solid;
		padding: 6px;
		display: inline-block;
		border-radius: 4px;
		text-align: center;
		min-width: 100%;
		font-size: 20px;
		background: #656464;
		color: #fefefe;
		border-color: #656464;
		margin: 5px 0px;
	}

	.card {
		padding-top: 10px;
	}

	#peopleResult .card .card-img-top,
	.allPeople .card .card-img-top {
		width: 42px;
		margin: auto;
		border-radius: 50%;
	}


	/* #peopleResult .card,#videoResult .card,.allVideo .card{
		background: #ebeaea;
	} */
	#videoResult .video-thumb,
	.allVideo .video-thumb {
		height: 350px;
		border-bottom: 1px solid #ccc;
	}

	#videoResult .video-thumb img,
	.allVideo .video-thumb img {
		height: 100%;
		object-fit: cover;
	}

	#videoResult .card-body p,
	.allVideo .card-body p {
		margin-bottom: .25rem !important;
	}

	.viewMore {
		padding: 6px 10px;
		display: inline-block;
		margin-top: 12px;
		color: #007bff !important;
		cursor: pointer;
	}

	.loadMoreResult {
		padding: 7px 14px;
		border: 0px;
		background: #c8cdcd;
		border-radius: 4px;
		cursor: pointer;
	}

	.loadMoreResult:focus {
		border: 0px;
		outline: none;
	}

	@media only screen and (min-width: 1200px) {
		#leukeVideos1 .video-container {
			height: 275px;
			margin-bottom: 0;
		}
	}

	#leukeVideos1 .video-container {
		position: relative;
		width: 100%;
		height: 300px;
		/* or any fixed height you want */
		overflow: hidden;
		border-radius: 2px;
	}

	#leukeVideos1 .video-container video {
		width: 100%;
		height: 100%;
		object-fit: cover;
		display: block;
		background-color: #000;
		border-radius: 2px;
	}

	#leukeVideos1 {
		grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
		display: grid;
		gap: 8px;
	}

	.right-container {
		overflow-y: scroll;
	}

	/* video 2 */

	@media only screen and (min-width: 1200px) {
		#leukeVideos2 .video-container {
			height: 275px;
			margin-bottom: 0;
		}
	}

	#leukeVideos2 .video-container {
		position: relative;
		width: 100%;
		height: 300px;
		/* or any fixed height you want */
		overflow: hidden;
		border-radius: 2px;
	}

	#leukeVideos2 .video-container video {
		width: 100%;
		height: 100%;
		object-fit: cover;
		display: block;
		background-color: #000;
		border-radius: 2px;
	}

	#leukeVideos2 {
		grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
		display: grid;
		gap: 8px;
	}

	*/
</style>
<section class="pt-4 vh-94">
	<div class="container-fluid">
		<div class="row align-items-center">
			<div class="col-xl-2 col-lg-2 col-md-2">
				@include('includes.leftSidebar')
			</div>

			<div class="col-xl-10 col-lg-10 col-md-10 m-auto">
				<div class="right-container m-auto">
					<div class="right-container m-auto">

						<div class="container-fluid">
							<div class="row">
								<div class="col-lg-12">

									<ul class="nav nav-tabs row" id="myTab" role="tablist">
										<li class="nav-item col-md-3 col-6">
											<a class="nav-link <?php echo ($active == 'A') ? 'active' : ''; ?>" id="all_tab" data-toggle="tab" href="#allResult" role="tab" aria-controls="allResult" aria-selected="true"> All</a>
										</li>
										<li class="nav-item col-md-3 col-6">
											<a class="nav-link <?php echo ($active == 'T') ? 'active' : ''; ?>" id="tags_tab" data-toggle="tab" href="#tagResult" role="tab" aria-controls="tagResult" aria-selected="true"> Tags</a>
										</li>
										<li class="nav-item col-md-3 col-6">
											<a class="nav-link <?php echo ($active == 'P') ? 'active' : ''; ?>" id="people_tab" data-toggle="tab" href="#peopleResult" role="tab" aria-controls="peopleResult" aria-selected="true"> People</a>
										</li>
										<li class="nav-item col-md-3 col-6">
											<a class="nav-link <?php echo ($active == 'V') ? 'active' : ''; ?>" id="video_tab" data-toggle="tab" href="#videoResult" role="tab" aria-controls="videoResult" aria-selected="true"> Video</a>
										</li>

									</ul>
								</div>
							</div>
							<div class="row">
								<div class="tab-content col-md-12" id="myTabContent">
									<div class="row tab-pane fade <?php echo ($active == 'A') ? 'show active' : ''; ?>" id="allResult" role="tabpanel" aria-labelledby="allResult">
										<div class="row">
											<div class="col-md-8">
												<h3 class="mt-2">Tags</h3>
											</div>
											@if(count($hashTags)>0)
											<div class="col-md-4 text-right"><a class="viewMore" id="viewMoreTags">View More</a></div>
											@endif
										</div>
										<div class="row allTag">
											<?php
											if (count($hashTags) > 0) {
												$x = 1;
												foreach ($hashTags as $tag) {
													$tagArr = explode(' ', $tag);
													foreach ($tagArr as $val) {
														if ($x <= 12) {
															if (strpos($val, $search)  !== false) {
											?>
																<div class="col-md-3 col-12">
																	<div class="card text-white bg-dark p-0 mb-3">
																		<div class="card-body p-1 text-center">
																			<?php if (strpos($val, '#') !== false) {
																				if ((strpos($val, '#')) == 0) {
																					$value = $val;
																					$par = trim($val, '#');
																				} else {
																					$value = '#' . $val;
																					$par = $val;
																				}
																			} else {
																				$value = '#' . $val;
																				$par = $val;
																			}

																			?>
																			<a class="pjax text-white" href="{{ route('web.tagVideos', $par) }}">
																				<h5 class="card-title m-1">
																					{{$value}}
																				</h5>
																			</a>
																		</div>
																	</div>
																</div>
												<?php $x++;
															}
														}
													}
												}
											} else { ?>
												<div class="col-md-12">
													<h6 class="mt-2">
														No Tag Found...
													</h6>
												</div>
											<?php }
											?>
										</div>
										<br />
										<hr />

										<div class="row">
											<div class="col-md-8">
												<h3 class="mt-2">People</h3>
											</div>
											@if(count($users)>0)
											<div class="col-md-4 text-right"><a class="viewMore" id="viewMorePeople">View More</a></div>
											@endif
										</div>
										<div class="row mt-2 allPeople">
											<?php
											// echo 'aaaaaa '.count($users);
											if (count($users) > 0) {
												foreach ($users as $user) { ?>
													<div class="col-lg-4 col-md-4 col-sm-6 col-12 mb-2">
														<div class="card pb-2">
															<img class="card-img-top" src="{{$user->user_dp}}" alt="Card image cap">
															<div class="card-body text-center">
																<h4 class="card-title "><a class="pjax" href="{{ route('web.userProfile', $user->user_id) }}"><?php echo ucfirst($user->fname) . ' ' . ucfirst($user->lname); ?></a></h4>
																<p class="card-text "><a class="pjax" href="{{ route('web.userProfile', $user->user_id) }}">{{ strtolower($user->username) }}</a></p>

																<span class="follow_btn" data-id="<?php echo $user->user_id; ?>" style="{{MyFunctions::getTopbarColor()}}">
																	<?php if ($user->follow > 0) {
																		echo "Unfollow";
																	} else {
																		echo "Follow";
																	} ?>
																</span>
															</div>
														</div>
													</div>
												<?php }
											} else { ?>
												<div class="col-md-12">
													<h6 class="mt-2">
														No Record Found...
													</h6>
												</div>
											<?php }
											?>
										</div>
										<br />
										<hr />
										<div class="row">
											<div class="col-md-8">
												<h3 class="mt-2">Videos</h3>
											</div>
											@if(count($videos))
											<div class="col-md-4 text-right"><a class="viewMore" id="viewMoreVideo">View More</a></div>
											@endif
										</div>


										<div class="" id="leukeVideos2">
											@php
											$count=0;
											$x = 1;
											@endphp
											@if($videos)
											@foreach ($videos as $video)
											@include("partials.userVideo")
											@php
											$count++;
											$x++;
											@endphp
											@endforeach

											@else
											<div class="col-md-12">
												<h6 class="mt-2">
													No Video Found...
												</h6>
											</div>
											@endif
										</div>


									</div>
									<div class="row tab-pane fade <?php echo ($active == 'T') ? 'show active' : ''; ?>" id="tagResult" role="tabpanel" aria-labelledby="tagResult">
										<div class="row">
											<div class="col-md-12">
												<h3 class="mt-2">Tags</h3>
											</div>
										</div>
										<div class="row moreTags">

											<?php
											foreach ($hashTags as $tag) { ?>
												<?php $tagArr = explode(' ', $tag);
												foreach ($tagArr as $val) {
													if (strpos($val, $search)  !== false) { ?>
														<div class="col-md-3 col-12">
															<!-- <span class="tag">{{'#'.$tag}}</span> -->
															<div class="card text-white bg-dark p-0 mb-3" style="max-width: 18rem;">
																<div class="card-body p-1 text-center">
																	<?php if (strpos($val, '#') !== false) {
																		if ((strpos($val, '#')) == 0) {
																			$value = $val;
																			$par = trim($val, '#');
																		} else {
																			$value = '#' . $val;
																			$par = $val;
																		}
																	} else {
																		$value = '#' . $val;
																		$par = $val;
																	} ?>
																	<a class="pjax text-white" href="{{ route('web.tagVideos', $par) }}">
																		<h5 class="card-title m-1">{{$value}}</h5>
																	</a>
																</div>
															</div>
														</div>
											<?php 	}
												}
											} ?>


										</div>
										@if($loadedVideoTags < $totalVideoTags)
											<div class="col-12 text-center">
											<button class="loadMoreResult m-2" type="T">Load More..</button>
									</div>
									@endif
								</div>
								<div class="row tab-pane fade <?php echo ($active == 'P') ? 'show active' : ''; ?>" id="peopleResult" role="tabpanel" aria-labelledby="peopleResult">
									<div class="row">
										<div class="col-md-12">
											<h3 class="mt-2">People</h3>
										</div>
									</div>
									<div class="row mt-2 morePeople">
										<?php foreach ($users as $user) { ?>
											<div class="col-lg-4 col-md-4 col-sm-6 col-12 mb-2">
												<div class="card pb-2">
													<img class="card-img-top" src="{{$user->user_dp}}" alt="Card image cap">
													<div class="card-body text-center">
														<h4 class="card-title "><a class="pjax" href="{{ route('web.userProfile', $user->user_id) }}"><?php echo ucfirst($user->fname) . ' ' . ucfirst($user->lname); ?></a></h4>
														<p class="card-text "><a class="pjax" href="{{ route('web.userProfile', $user->user_id) }}">{{ strtolower($user->username) }}</a></p>

														<span class="follow_btn" data-id="<?php echo $user->user_id; ?>" style="{{MyFunctions::getTopbarColor()}}">
															<?php if ($user->follow > 0) {
																echo "Unfollow";
															} else {
																echo "Follow";
															} ?>
														</span>
													</div>
												</div>
											</div>
										<?php } ?>
									</div>
									@if($loadedPeople < $totalPeople)
										<div class="col-12 text-center">
										<button class="loadMoreResult m-2" type="P">Load More..</button>
								</div>
								@endif
							</div>
							<div class="row tab-pane fade <?php echo ($active == 'V') ? 'show active' : ''; ?>" id="videoResult" role="tabpanel" aria-labelledby="videoResult">
								<div class="row">
									<div class="col-md-12">
										<h3 class="mt-2">Videos</h3>
									</div>
								</div>
								<div class="mt-2 moreVideo" id="leukeVideos1">
									@php
									$count=0;
									$x = 1;
									@endphp
									@if($videos)
									@foreach ($videos as $video)
									@include("partials.userVideo")
									@php
									$count++;
									$x++;
									@endphp
									@endforeach

									@else
									<div class="col-md-12">
										<h6 class="mt-2">
											No Video Found...
										</h6>
									</div>
									@endif
									@if($loadedVideos < $totalVideos)
										<!-- <div class="col-12 text-center">
										<button class="loadMoreResult m-2" type="V">Load More..</button>
								</div> -->
								@endif
							</div>
						</div>
					</div>
				</div>

			</div>
		</div>
	</div>
	</div>

	<!-- Modal -->
	@include('partials.leukeModal')

</section><!-- about -->
@include('includes.modalVideoJs')
@endsection