@extends('layouts.front')

@section('content')
<style>
	.bg-btn {
		/* background: linear-gradient(50deg, rgb(115,80,199) 0%, rgb(236,74,99) 100%); */

		padding: 10px 0;
		color: #fff;
		border-radius: 2px;
	}

	.card .card-body .message {
		padding-left: 80px;
		text-align: left;
	}

	.message .card-title a {
		color: #fff;
	}

	.message .card-subtitle {
		color: #aaa;
	}

	.message .card-title,
	.message .card-subtitle {
		margin-bottom: 8px;
	}

	.avatar_img {
		width: 57px;
		/* width: 7%; */
	}

	.card .card-body .actions {
		margin-top: 5px;
	}
</style>
<!-- include('includes.topbar') -->
<section class="pt-4 vh-94">
	<div class="row align-items-center">
		<div class="col-lg-12">
			<div class="about-content privacy">
				<div class="container-fluid">
					<div class="row">
						<div class="col-xl-2 col-lg-2 col-md-2">
							@include('includes.leftSidebar')
						</div>

						<div class="col-xl-10 col-lg-10 col-md-10 m-auto">
							<div class="right-container m-auto">
								<div class="container-fluid">
									<div class="row user_profile_top">
										<div class="col-xl-2 col-lg-3 col-md-3 col-4">
											<a href="{{ route('web.userProfile',$userInfo->user_id) }}">
												<?php if (!empty($userInfo->user_dp)) {
													if (strpos($userInfo->user_dp, 'fbsbx.com') !== false || strpos($userInfo->user_dp, 'googleusercontent.com') !== false || strpos($userInfo->user_dp, 'facebook.com') !== false) {
														$user_dp = $userInfo->user_dp;
													} else {
														// $exists = Storage::disk(config('app.filesystem_driver'))->exists('public/profile_pic/'.$userInfo->user_id.'/small/'.$userInfo->user_dp);
														//dd(Storage::url('public/profile_pic/' . $userInfo->user_id). '/small/' . $userInfo->user_dp);
														// if($exists){ 
														// if(file_exists(public_path('storage/profile_pic').'/'.$userInfo->user_id.'/small/'.$userInfo->user_dp)){
														$user_dp = asset(Storage::url('public/profile_pic/' . $userInfo->user_id) . '/small/' . $userInfo->user_dp);
														// }else{
														//     $user_dp=asset('storage/profile_pic/default.png');
														// } 
													}
												} else {
													$user_dp = asset('default/default.png');
												} ?>
												<img class="rounded-circle img-responsive" src="{{ $user_dp }}" alt="" />
											</a>
										</div>
										<div class="col-xl-10 col-lg-9 col-md-9 col-8 pt-2 ">
											<div class="row">
												<div class="col-md-12 p-0 ">
													<a href="{{ route('web.userProfile',$userInfo->user_id) }}">
														<h4 style="text-transform: capitalize;color:#dddddd;cursor:pointer">{{ $userInfo->fname }} {{ $userInfo->lname }}</h4>
													</a>
												</div>
												<a href="{{ route('web.userProfile',$userInfo->user_id) }}">
													<h5 class="col-lg-8 col-md-8 p-0" style="color:#aaa">{{ '@'.$userInfo->username }} <?php if ($userInfo->verified == 'A') { ?>
															<img src="{{ asset('default/verified-icon-blue.png') }}" alt="" style="width:15px;height:15px;">
														<?php } ?>
													</h5>
												</a>
											</div>
											<div class="row mb-3">
												<div class="col-md-12 col-12 p-0 pt-1 userProfileLinks">
													<span class="pl-1 pr-1 "><a href="{{ route('web.userProfile',$userInfo->user_id) }}"><strong>{{ !empty($userInfo->total_videos) ? $userInfo->total_videos : '0' }}</strong> videos</a></span>
													<span class="pl-1 pr-1 text-center"><strong>{{ !empty($userInfo->total_likes) ? $userInfo->total_likes : '0' }}</strong> likes</span>
													<span class=" pl-1 pr-1  text-center"><a href="{{ route('web.followers-list',$userInfo->user_id)}}"><strong>{{ $followers }}</strong> followers</a></span>
													<span class="pl-1 pr-1  text-right"><a href="{{ route('web.following-list',$userInfo->user_id)}}"><strong>{{ $following }}</strong> following</a></span>
												</div>
											</div>
											<!-- </div> -->
											<div class="row mb-3">
												<div class="col-md-3 col-6 pt-1 p-0 ">
													@if (auth()->guard('web')->check())
													@if (auth()->guard('web')->user()->user_id == $userInfo->user_id)
													<a class="btn col-md-3 small d-inline" href="{{ route('web.editUserProfile', $userInfo->user_id) }}" style="padding:8px">
														<!-- <i class="fa fa-edit"></i> --> Edit Profile
													</a>
													@endif
													@endif

													@if(!$blocked)
													<div class="p-0 pr-2 small d-inline">

														@if ($canFollow && $blocked==false)
														<a class="btn col-md-3 small d-inline" onclick="followUnfollow('{{ $userInfo->user_id }}')" style="padding:8px;">
															<span id="followUnfollow">
																@if(!$followed) Follow @else Unfollow @endif</span>
														</a>
														@endif
													</div>
													@endif
													@if (auth()->guard('web')->check())
													@if (auth()->guard('web')->user()->user_id != $userInfo->user_id && $blocked==false)
													<div class="p-0 pr-2 small d-inline">
														<a onclick="blockUnblock('{{ $userInfo->user_id }}')" class="btn col-md-3 d-inline" style="padding:8px;">

															<span id="blockUnblock">
																@if(!$blocked) Block @else Unblock @endif
															</span>
														</a>
													</div>
													@endif
													@endif
												</div>
											</div>
										</div>
									</div>
									<hr>
									<div class="row">
										<div class="col-lg-12">
											<h5>Followers</h5><br />

											<div id="follow">
												<?php
												if (count($followersList) > 0) {
													foreach ($followersList as $follower) { ?>

														<div class="card">
															<div class="card-body">
																<?php
																if ($follower->user_dp != "") {
																	if (strpos($follower->user_dp, 'facebook.com') !== false || strpos($follower->user_dp, 'fbsbx.com') !== false || strpos($follower->user_dp, 'googleusercontent.com') !== false) {
																		$u_dp = $follower->user_dp;
																	} else {
																		$u_dp = asset(Storage::url('public/profile_pic') . '/' . $follower->user_id . '/small/' . $follower->user_dp);
																	}
																} else {
																	$u_dp = asset('default/default.png');
																} ?>
																<img src="{{$u_dp}}" class="avatar_img float-left rounded-circle">
																<div class="message">
																	<h5 class="card-title"><a href="{{ route('web.userProfile', $follower->user_id) }}">{{ $follower->fname.' '.$follower->lname }} <?php if ($follower->verified == 'A') { ?>
																				<img src="{{ asset('default/verified-icon-blue.png') }}" alt="" style="width:15px;height:15px;">
																			<?php } ?></a></h5>
																	<h6 class="card-subtitle">{{ '@' . $follower->username }}</h6>
																	<?php if ($follower->user_id != auth()->guard('web')->user()->user_id) {
																	?>
																		<span class="follow_btn" data-id="<?php echo $follower->user_id; ?>" style="{{MyFunctions::getTopbarColor()}}">
																			<?php if ($follower->follow > 0) {
																				echo "Unfollow";
																			} else {
																				echo "Follow";
																			} ?>
																		</span>
																	<?php } ?>
																	<!-- <p class="card-text">Some quick example text to build on the card title and make up the bulk of the card's content.</p> -->
																</div>
																<!-- <div class="actions">
													<a href="#" class="card-link">Like</a>
													<a href="#" class="card-link">Reply</a>
													<a href="#" class="card-link">Share</a>
												</div> -->
															</div>
														</div>
													<?php }
												} else { ?>
													<div class="card bg-dark">
														<div class="card-body">
															<h6>No Follower...</h6>
														</div>
													</div>
												<?php } ?>
											</div>

											<div class="loadMore text-center col-12">
												<img src="{{ asset('default/loading.gif') }}" style="width:35px;margin-top:10px;">
											</div>

											<br />
										</div>


									</div>
								</div>

							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

</section><!-- about -->

@endsection