@extends('layouts.front')

@section('content')

<style>
  .action-icon {
    padding-top: 3px;
  }


  @media only screen and (min-width: 1200px) {
    #leukeVideos1 .video-container {
      height: 275px;
      margin-bottom: 0;
    }
  }

  #leukeVideos1 .video-container {
    position: relative;
    width: 100%;
    height: 300px;
    /* or any fixed height you want */
    overflow: hidden;
    border-radius: 2px;
  }

  #leukeVideos1 .video-container video {
    width: 100%;
    height: 100%;
    object-fit: cover;
    display: block;
    background-color: #000;
    border-radius: 2px;
  }

  #leukeVideos1 {
    grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
    display: grid;
    gap: 8px;
  }
  /* .right-container {
    overflow-y: scroll;
  } */
</style>

<section class="pt-4 vh-94">
  <div class="container-fluid">
    <div class="row align-items-center">
      <div class="col-xl-2 col-lg-2 col-md-2">
        @include('includes.leftSidebar')
      </div>

      <div class="col-xl-10 col-lg-10 col-md-10 m-auto">
        <div class="right-container m-auto">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12 p-0 mb-3 tag-slider">
                <div class="slider-container">
                  <button class="slider-arrow arrow-left" onclick="scrollSlider(-200)">
                    <i class="fa fa-angle-left fa-2x"></i>
                  </button>

                  <div class="slider-track" id="titleSlider">
                     <div class="title-box {!! !(request()->hashtag) ? 'active' : '' !!}"><a href="{{ route('web.home') }}?explore=true" >All</a></div>
                    @foreach($hashTags as $tag)
                    @php $tag=str_replace('#', '', $tag); @endphp
                    <div class="title-box {!! (request()->hashtag==$tag) ? 'active' : '' !!}"><a href="{{ route('web.home') }}?explore=true&hashtag={{$tag}}" >{{$tag}}</a></div>
                    @endforeach
                  </div>

                  <button class="slider-arrow arrow-right" onclick="scrollSlider(200)">
                    <i class="fa fa-angle-right fa-2x"></i>
                  </button>
                </div>
              </div>
            </div>
            <div class="row">
              <!-- <div class="col-12">
                <h4>Explore</h4>
              </div> -->
              <div class="col-lg-12  col-sm-12 mb-5">
                <div class="row" id="leukeVideos1">
                  @php
                  $count=0;
                  $x = 1;
                  @endphp
                  @foreach ($videos as $video)
                  @include("partials.userVideo")
                  @php
                  $count++;
                  $x++;
                  @endphp
                  @endforeach
                </div>
                <div class="loadMore text-center col-12">
                  <img src="{{ asset('default/loading.gif') }}" style="width:35px;margin-top:10px;">
                </div>
              </div>

            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

    <!-- Modal -->
@include('partials.leukeModal')

</section>

@include('includes.modalVideoJs')
<script type="text/javascript">


  $(document).click('input:checkbox', function() {
    // $('input:checkbox').on('click',function(){
    if ($('input[name="chk[]"]:checked').length > 0) {
      $('#delete-btn').css({
        'display': 'block'
      });
    } else {
      $('#delete-btn').hide({
        'display': 'none'
      });
    }
    1
  });

  const slider = document.getElementById('titleSlider');
  const leftArrow = document.querySelector('.arrow-left');
  const rightArrow = document.querySelector('.arrow-right');

  function scrollSlider(amount) {
    slider.scrollBy({ left: amount, behavior: 'smooth' });

    // Wait for scroll to complete before checking
    setTimeout(updateArrows, 300);
  }

  function updateArrows() {
    const scrollLeft = slider.scrollLeft;
    const scrollWidth = slider.scrollWidth;
    const clientWidth = slider.clientWidth;

    // Show/hide left arrow
    if (scrollLeft > 0) {
      leftArrow.style.display = 'block';
    } else {
      leftArrow.style.display = 'none';
    }

    // Show/hide right arrow
    if (scrollLeft + clientWidth < scrollWidth - 1) {
      rightArrow.style.display = 'block';
    } else {
      rightArrow.style.display = 'none';
    }
  }

  // Update arrows on load and when user scrolls
  window.addEventListener('load', updateArrows);
  slider.addEventListener('scroll', updateArrows);
  window.addEventListener('resize', updateArrows);
</script>

@endsection