@foreach($videos as $video)
<div class="row">
    <div class="col-xl-8 col-lg-7 col-sm-8 col-12">
        <div class="card">
            <div class="video" id="video-{{$video->video_id}}" data-video-id="{{$video->video_id}}">
                <div class="video-container">
                    <div class="video-main ">
                        <div class="video-sub ">
                            <div class="home-video d-flex {!! ($video->wide == 1) ? 'h-active-video video-section' : '' !!}">
                                <div class="ModelCtrlBtn"><i class="fa fa-pause ctrlIcon"></i></div>
                                <div class="ModelSpeakerBtn"><i class="fa fa-volume-off spkIcon"></i></div>
                                <video id="video{{$video->video_id}}" muted loop onclick="modelVideo('video{{$video->video_id}}')" onmouseover="showIcon()" onmouseout="hideIcon()">
                                    <source src="{{ asset(Storage::url('public/videos/' . $video->user_id . '/' . $video->video )) }}" type="video/mp4">
                                </video>
                                <div class="views ">
                                    <div class="text-center">
                                        <div class="home-like-{{$video->video_id}} home_like" data-id="{{ $video->video_id}}">
                                            @if($video->liked >0)
                                            <i class="fa fa-heart red"></i>
                                            @else
                                            <i class="fa fa-heart"></i>
                                            @endif
                                            <p class="span-text">{{ $video->total_likes }}</p>
                                        </div>


                                        <div class="">
                                            <i class="fa fa-comment"></i>
                                            <p class="span-text">{{$video->total_comments}}</p>
                                        </div>

                                        <div class=" video_share  share-wrapper" style="position: relative; display: inline-block;" data-id="{{ $video->video_id }}">

                                            <!-- <i id="video-share" class="fa fa-share-square-o "></i> -->
                                           <div class="share-wrapper">

                                           @php
                                           $socialLink = utf8_decode(urldecode(route('open-video',$video->video_id)));
                                           $facebookLink = Share::page($socialLink, '')->facebook()->getRawLinks();
                                            $twitterLink = Share::page($socialLink, null)->twitter()->getRawLinks();
                                            $whatsappLink = Share::page($socialLink)->whatsapp()->getRawLinks();
                                            @endphp
                                            <i class="fa fa-share-square-o share-btn" id="video-share" data-id="{{ $video->video_id }}"></i>
                                            <div id="popover-{{ $video->video_id }}" class="popover-content" style="display: none;">
                                                <div class="d-flex flex-row justify-content-around">
                                                    <a href="{{ $facebookLink }}" class="facebook-link" target="_blank">
                                                        <i class="fa fa-facebook-square fa-2x ml-2"></i>
                                                    </a>
                                                    <a href="{{ $twitterLink }}" class="twitter-link" target="_blank">
                                                        <i class="fa fa-twitter-square fa-2x ml-2"></i>
                                                    </a>
                                                    <a href="{{ $whatsappLink }}" class="whatsapp-link" target="_blank">
                                                        <i class="fa fa-whatsapp fa-2x ml-2 mb-2 mr-2"></i>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                        </div>
                                    </div>
                                </div>


                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @if (!auth()->guard('web')->check())
    <div class="col-xl-4 col-lg-3 col-sm-4 col-12 comment-section " style="background-image: url('default/comment-s.jpg'); background-size: 100% 100%;background: #000;">
    @else
    <div class="col-xl-4 col-lg-3 col-sm-4 col-12 comment-section ">
        @endif
        <div class="modal-right-section" data-video-id="{{$video->video_id}}">
            <?php if (!empty($video->user_dp)) {
                if (strpos($video->user_dp, 'fbsbx.com') !== false || strpos($video->user_dp, 'googleusercontent.com') !== false || strpos($video->user_dp, 'facebook.com') !== false) {
                    $user_dp = $video->user_dp;
                } else {
                    $user_dp = asset(Storage::url('public/profile_pic/' . $video->user_id) . '/small/' . $video->user_dp);
                }
            } else {
                $user_dp = asset('default/default.png');
            } ?>
            <div class="row">
                <div class="col-12 pt-2">
                    <div class="dp_container mr-3 d-inline-block">
                        <a href="{{ route('web.userProfile',$video->user_id) }}">
                            <img class="img-fluid" src="{{ $user_dp }}" width="50" height="50">
                        </a>
                    </div>

                    <div class="d-inline-block">
                        <div class="modal_user_name d-inline">
                            <span class="video_user_name"><?php echo '@' . $video->username; ?></span>
                            @if($video->verified == 'A')
                            <span class="verified_account">
                                <img src="{{ asset('default/verified-icon-blue.png') }}" alt="" style="width: 15px; height: 15px;">
                            </span>
                            @endif
                        </div>
                        @if(isset(auth()->user()->user_id) && auth()->user()->user_id!=$video->user_id)
                        <div class="follow_div d-inline">
                            <span class="follow_btn " data-id="<?php echo $video->user_id; ?>">
                                @if($video->follow)
                                Unfollow
                                @else
                                Folllow
                                @endif
                            </span>
                        </div>
                        @endif
                        <br />
                        <div class="video_view modal_video_view my-2" style="{{ MyFunctions::getTopbarColor() }}"><i class="fa fa-eye"></i> <span class="views_count">{{$video->total_views}}</span></div>
                    </div>
                </div>
                <div class="col-12">

                    <div class="video_title">{!! $video->description !!}
                        <br />
                        @if(isset($video->tags) && $video->tags!="")
                        <br />
                        @php $tags=explode(' ',$video->tags) @endphp
                        @foreach($tags as $tag)
                        @php $tag=trim($tag,"#") @endphp
                        @if($tag!="")
                        <a href="{{ route('web.tagVideos', $tag) }}" class="tags">{!! '#'.$tag !!}</a>
                        @endif
                        @endforeach
                        @endif

                    </div>
                </div>
            </div>
            <hr />
            @if (auth()->guard('web')->check())
            <h5 style="margin: 20px 0;">Comments</h5>
            @endif
            <input type="hidden" id="video_id" value="">
            <div class="modal-comment-list" style="{{ !(auth()->user()) ? 'opacity: 0.5;' : '' }}"></div>

            @if (auth()->guard('web')->check())
            <div class="modal-video-comment mt-1">
                <form action="{{ route('web.videoPostComments', $video->video_id) }}" id="modal-comment-form{{$video->video_id}}" class="modal-comment-form" method="POST">
                    @csrf
                    <div class="d-flex flex-row justify-content-around p-2 border" style="border-radius: 9999px; background-color: #f6f4f4; width: 100%;">
                        <input type="hidden" name="id" value="{{ $video->video_id}}" />
                        <input type="text" name="video_comment" class="border-0 video_comment" placeholder="Add Your Comment" style="width: 100%; height: 30px; background-color: #f6f4f4; padding: 15px;">
                        <a href="javascript:void(0)" style="margin: auto; padding-right: 10px"><i class="fa fa-paper-plane-o" aria-hidden="true" onclick="$('#modal-comment-form{{$video->video_id}}').submit();"></i></a>
                    </div>
                </form>
                <br>
            </div>
            @endif

            @if (!auth()->guard('web')->check())
            <div class="send-comment-area">
                <div class="card">
                    <h4>Login To See &<br>Add Comments</h4>
                    <div class="please-login text-center">
                        <a href="{{ route('web.login') }}" class="pjax" onclick="profileshow()">
                            <button class="btn model-login-btn" style="{{ MyFunctions::getTopbarColor() }}">Login / Register with Email</button>
                        </a>
                        <a href="{{ route('web.login') }}" class="pjax" onclick="profileshow()">
                            <button class="btn model-google-btn"><img width="16px" src="{{ asset('default/Google__G__Logo.png') }}"> Sign In With Google</button>
                        </a>
                    </div>
                </div>
            </div>
            @endif
        </div>

    </div>
</div>
@endforeach