<div class="video ">
	<?php

use App\Helpers\Common\Functions;
	if ($video->user_dp != "") {
		if (strpos($video->user_dp, 'facebook.com') !== false || strpos($video->user_dp, 'fbsbx.com') !== false || strpos($video->user_dp, 'googleusercontent.com') !== false) {
			$u_dp = $video->user_dp;
		} else {
			$u_dp = asset(Storage::url('public/profile_pic') . '/' . $video->user_id . '/small/' . $video->user_dp);
		}
	} else {
		$u_dp = asset('default/default.png');
	}
	?>

	<div class="video-container">
		<div class="video-main ">
			<div class="video-sub ">
				<div class="home-video d-flex {{ ($video->wide==1) ? 'h-active-video' : '' }}" >
					<video style="{{ ($video->wide==1) ? 'width:100%' : ''  }}" controls muted id="video_{{$count}}" loop preload="none" poster="{{ asset(Storage::url('public/videos/' . $video->user_id . '/thumb/' . $video->thumb )) }}">
						<source src="{{ asset(Storage::url('public/videos/' . $video->user_id . '/' . $video->video )) }}" type="video/mp4">
					</video>

					<div class="title_div">
						<div class="mb-1">@<?php echo $video->username; ?>
							<?php if ($video->verified == 'A') { ?>
								<img src="{{ asset('default/verified-icon-blue.png') }}" alt="" style="width:15px;height:15px;">
							<?php } ?>
						</div>
						<?php if((strlen($video->description) > 100)){ ?>
							<span class="desc"><?php echo Functions::descTags(mb_substr($video->description, 0, 100)); ?></span>
							<span class="show_more" data-desc="{!! Functions::descTags($video->description) !!}">show more</span>
						<?php }else{ ?>
								{!! Functions::descTags($video->description) !!}
						<?php } ?>					</div>


					<div class="views ">
						<div class="text-center" id="video_actions_{{$video->video_id}}">
							@php $userId=0 @endphp
							@if(auth()->user())
							@php $userId=auth()->user()->user_id @endphp
							@endif

							<div class="dp_container">
								<a href="{{ route('web.userProfile',$video->user_id) }}">
									<img class="img-fluid" src="<?php echo $u_dp; ?>">
									@if($video->user_id!=$userId)
									<span class="home_follow_btn" data-id="{{ $video->user_id}}">
										@if ($video->follow > 0)
										<i class="fa fa-check follow-icon"></i>
										@else
										<i class="fa fa-plus follow-icon"></i>
										@endif
									</span>
									@endif
								</a>
							</div>

							
							<div class="home-like-{{$video->video_id}} home_like" data-id="{{ $video->video_id}}">
								<!-- <img src="{{ asset('default/heart_img_w_icon.svg') }}" width="35px"> -->
								@if($video->liked >0)
								<i class="fa fa-heart red"></i>
								@else
								<i class="fa fa-heart"></i>
								@endif
								<p class="span-text">{{ $video->total_likes }}</p>
							</div>

							<div class="home-comment-{{$video->video_id}} video-item" data-id="{{ $video->video_id }}" data-url="{{ asset(Storage::url('public/videos/' . $video->user_id . '/' . $video->video )) }}" data-toggle="modal" data-target="#LeukeModal">
								<!-- <img src="{{ asset('default/message_img_icon.svg') }}" width="35px"> -->
								<i class="fa fa-comment"></i>
								<p class="span-text">{{ $video->total_comments }}</p>
							</div>
							<!-- <i class="fa fa-heart-o" aria-hidden="true"></i> {{ $video->total_likes }}
									<i class="fa fa-comment-o" aria-hidden="true"></i> {{ $video->total_comments }} -->
							<!-- </div> -->
						</div>
					</div>
				</div>
			</div>

		</div>


	</div>
	<!-- <div class="user_name">
																<div>@<?php echo $video->username; ?>
																<?php if ($video->verified == 'A') { ?>
																	<img src="{{ asset('default/verified-icon-blue.png') }}" alt="" style="width:15px;height:15px;">
																<?php } ?>
															</div>
															<div class="video_view" id="video_view_{{$video->video_id}}" style="{{MyFunctions::getTopbarColor()}}"><i class="fa fa-eye"></i> {{$video->total_views}}</div>
														</div> -->

</div>