<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="UTF-8">
	<title><?php echo MyFunctions::getSiteTitle(); ?></title>
	<meta name="csrf-token" content="{{ csrf_token() }}">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<?php $version = MyFunctions::getCurrentVersion(); ?>
	<link rel="stylesheet" href="{{ asset('css/animate.css?v=').$version }}">
	<link rel="stylesheet" href="{{ asset('css/lightcase.css?v=').$version }}">
	<link rel="stylesheet" href="{{ asset('css/simple-line-icons.css?v=').$version }}">
	<link rel="stylesheet" href="{{ asset('css/ElegantIcons.css?v=').$version }}">
	<link rel="stylesheet" href="{{ asset('css/swiper.min.css?v=').$version }}">
	<link rel="stylesheet" href="{{ asset('css/font-awesome.min.css?v=').$version }}">
	<!-- <link rel="stylesheet" href="{{-- asset('css/fontawesome.min.css?v=').$version --}}"> -->
	<link rel="stylesheet" href="{{ asset('css/bootstrap.min.css?v=').$version }}">

	<link rel="stylesheet" href="{{ asset('css/front-style.css?v=').$version }}">
	<link rel="stylesheet" href="{{ asset('css/home-4-style.css?v=').$version }}">
	<link rel="stylesheet" href="{{ asset('css/video-style.css?v=').$version.'1' }}">
	<link rel="stylesheet" href="{{ asset('css/responsive.css?v=').$version }}">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.css" />
	<!-- <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.0.0/jquery.min.js"></script> -->
	<script src="{{ asset('js/jquery-2.2.3.min.js?v=').$version }}"></script>
	<script data-cfasync="false" src="{{ asset('js/app.js?v=').$version }}"></script>
	<script src="{{ asset('js/fontawesome.min.js?v=').$version }}"></script>
	<link rel="stylesheet" href="{{ asset('css/letmesoul.css?v=').$version }}" />
	@php
	$theme = session('theme', 'light'); // default to light
	@endphp
	@if($theme=='light')
		<link rel="stylesheet" href="{{ asset('css/light.css?v=').$version }}" />
		@else
		<link rel="stylesheet" href="{{ asset('css/dark.css?v=').$version }}" />
	@endif

</head>

<body>
	@php
	$userId = 0;
	if(auth()->guard('web')->check()) {
	$userId = auth()->guard('web')->user()->user_id;
	}
	@endphp

	<!-- header -->

	@yield('content')

<!-- Modal -->
	{{--
	<div class="modal fade mx-auto" id="LeukeModal1111" tabindex="-1" role="dialog" aria-labelledby="exampleModalLongTitle" aria-hidden="true" style="height:100vh;background:#000;">
		<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
			<div class="modal-content">
				<div class="modal-body p-0">
					<div class="container-fluid">
						<button type="button" class="close d-lg-none d-block" data-dismiss="modal" aria-label="Close">
								<span aria-hidden="true">×</span>
							</button>
						<div class="row">
							
							<div class="col-xl-8 col-lg-7 col-sm-8 col-12">
								<div class="card">
									<div class="video">
										<div class="video-container">
											<div class="video-main ">
												<div class="video-sub ">
													<div class="home-video d-flex">

														<!-- <div class="video-section" onclick="play()"> -->
														<div class="ModelCtrlBtn"><i class="fa fa-pause" id="ctrlIcon"></i></div>
														<video id="leukeVideo" autoplay loop onclick="modelVideo()" onclick="play()" onmouseover="showIcon()" onmouseout="hideIcon()">
															<source src="" type="video/mp4">
														</video>
														<div class="views ">
															<div class="text-center">

																<div class="" id="video-like">
																	<!-- <img src="{{ asset('default/heart_img_w_icon.svg') }}" width="35px"> -->

																	<i class="fa fa-heart"></i>

																	<p class="span-text">0</p>
																</div>

																<div class="">
																	<!-- <img src="{{ asset('default/message_img_icon.svg') }}" width="35px"> -->
																	<i class="fa fa-comment"></i>
																	<p class="span-text">0</p>
																</div>

																<div class=" video_share  ">
																	<i id="video-share" class="fa fa-share-square-o "></i>

																</div>

															</div>
														</div>
													</div>
													<!-- <div class="modal-video-post-action row">
										<div class="modal-main-action col-md-12">
											<div class="row text-center model-action-text">
												<div class=" col-12  float-right">
													<img id="video-like" src="{{ asset('default/heart_img_w_icon.svg') }}" width="40px" onclick="videoLike()">
													<br>Like
												</div>
												<div class=" col-12  float-right mt-5">
													<i id="video-share" class="fa fa-share-square-o ml-2"></i>
													<br>Share
												</div>
											</div>
										</div>
									</div> -->
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>

							@if (!auth()->guard('web')->check())
							<div class="col-xl-4 col-lg-3 col-sm-4 col-12 comment-section " style="background-image: url('default/comment-s.jpg'); background-size: 100% 100%;background: #000;">
								@else
								<div class="col-xl-4 col-lg-3 col-sm-4 col-12 comment-section ">
									@endif
									<div class="modal-right-section">

										@php $user_dp = asset('default/default.png'); @endphp
										<div class="row">
											<div class="col-12">
												<div class="dp_container mr-3 d-inline-block">
													<a href="javascript:void(0)">
														<img class="img-fluid" src="{{ $user_dp }}" width="50" height="50">
													</a>
												</div>

												<div class="d-inline-block">
													<div class="modal_user_name d-inline">
														@<span class="video_user_name">ssss</span>
														<span class="verified_account">
															<img src="{{ asset('default/verified-icon-blue.png') }}" alt="" style="width: 15px; height: 15px;">
														</span>
													</div>
													<div class="follow_div d-inline"></div>
													<br />
													<div class="video_view modal_video_view my-2" style="{{ MyFunctions::getTopbarColor() }}"><i class="fa fa-eye"></i> <span class="views_count">0</span></div>
												</div>
											</div>
											<div class="col-12">
												
												<div class="video_title"></div>
											</div>
										</div>
										<hr />
										@if (auth()->guard('web')->check())
										<h5 style="margin: 20px 0;">Comments</h5>
										@endif
										<input type="hidden" id="video_id" value="">
										<div class="modal-comment-list" id="modal-comment-list"></div>

										@if (auth()->guard('web')->check())
										<div class="modal-video-comment mt-1" id="modal-video-comment">
											<form action="" id="modal-comment-form" method="POST">
												@csrf
												<div class="d-flex flex-row justify-content-around p-2 border" style="border-radius: 9999px; background-color: #f6f4f4; width: 100%;">
													<input type="text" name="video_comment" class="border-0" id="video_comment" placeholder="Add Your Comment" style="width: 100%; height: 30px; background-color: #f6f4f4; padding: 15px;">
													<a href="javascript:void(0)" style="margin: auto; padding-right: 10px"><i class="fa fa-paper-plane-o" aria-hidden="true" onclick="$('#modal-comment-form').submit();"></i></a>
												</div>
											</form>
											<br>
										</div>
										@endif

										@if (!auth()->guard('web')->check())
										<div class="send-comment-area">
											<div class="card">
												<h4>Login To See &<br>Add Comments</h4>
												<div class="please-login text-center">
													<a href="{{ route('web.login') }}" class="pjax" onclick="profileshow()">
														<button class="btn model-login-btn" style="{{ MyFunctions::getTopbarColor() }}">Login / Register with Email</button>
													</a>
													<a href="{{ route('web.login') }}" class="pjax" onclick="profileshow()">
														<button class="btn model-google-btn"><img width="16px" src="{{ asset('default/Google__G__Logo.png') }}"> Sign In With Google</button>
													</a>
												</div>
											</div>
										</div>
										@endif
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	--}}

	<?php if (Route::currentRouteName() != 'web.home' && (Route::currentRouteName() != 'web.messages')) { ?>
		<footer>
			<div class="row bottom_bar">
				<div class="col-md-4">
					<p class="copyright">&copy {{ date('Y') }} <span class="text-uppercase"><?php echo MyFunctions::getSiteTitle(); ?></span> All Rights Reserved</p>
				</div>
				<div class="col-md-4">
					<a href="{{ url('about-us') }}">About Us</a> | <a href="{{ url('privacy-policy') }}">Privacy</a> | <a href="{{ url('terms') }}">Terms of Use</a> | <a href="{{ url('data-delete') }}">Data Deletion</a>
				</div>
				<div class="col-md-4  video-sm text-center">
					<?php $links = MyFunctions::getSocialMediaLinks();
					?>
					<ul style="display: inline-flex;">
						<li><a href="<?php echo isset($links->fb_link) ? $links->fb_link : '#'; ?>"><i class="fa fa-facebook-official" aria-hidden="true"></i></a></li>
						<li><a href="<?php echo isset($links->twitter_link) ? $links->twitter_link : '#'; ?>"><i class="fa fa-twitter" aria-hidden="true"></i></a></li>
						<li><a href="<?php echo isset($links->google_link) ? $links->google_link : '#'; ?>"><i class="fa fa-google" aria-hidden="true"></i></a></li>
						<li><a href="<?php echo isset($links->youtube_link) ? $links->youtube_link : '#'; ?>"><i class="fa fa-youtube-play" aria-hidden="true"></i></a></li>
					</ul>
				</div>

			</div>
		</footer>
	<?php } ?>
	<?php if (Route::currentRouteName() != 'web.messages') { ?>
		<div class="scroll-top" style="{{MyFunctions::getTopbarColor()}}">
			<i class="fa fa-arrow-up" aria-hidden="true"></i>
		</div>
	<?php } ?>
	<div class="main-search-area">
		<form class="main-search-form full-view">
			<div class="m-s-input">
				<input type="search" name="search" class="search-input" placeholder="Search..." autocomplete="off">
			</div>
			<span>Type and Hit Enter to Search</span>
		</form>
		<script src="{{ asset('js/sweetalert.min.js') }}"></script>

		<i class="icon_close"></i>
	</div>

	<script>
		$(document).ready(function() {

			$('[data-toggle="popover"]').popover();

			<?php if (Route::currentRouteName() == 'web.tagVideos') { ?>

				var searchUrl = "{{route('web.tagVideos',['val'=>$search])}}";
				var page = 1;
				var totalVideos = <?php echo $totalVideos; ?>;
				var loadedVideos = <?php echo $loadedVideos; ?>;
				//videos
				$(document).on('click', '#videoResult .loadMoreResult', function() {
					var type = $(this).attr('type');
					page = page + 1;
					$.ajax({
						type: "GET",
						url: searchUrl,
						data: {
							page: page
						},
						dataType: "json",
						success: function(response) {
							if (response.html != '') {
								page = page;

								totalVideos = response.totalVideos;
								loadedVideos = loadedVideos + response.loadedVideos;
								if (totalVideos <= loadedVideos) {
									$('#videoResult .loadMoreResult').hide();
								}
								$('.moreVideo').append(response.html);

							}
						}
					});
				});
			<?php } ?>
			<?php if (Route::currentRouteName() == 'web.searchAll') { ?>
				$("#viewMoreTags").click(function() {
					$('#tags_tab').trigger("click");
				});
				$("#viewMorePeople").click(function() {
					$('#people_tab').trigger("click");
				});
				$("#viewMoreVideo").click(function() {
					$('#video_tab').trigger("click");
				});


				var searchUrl = "{{route('web.searchAll')}}";

				var vpage = 1;
				var ppage = 1;
				var tpage = 1;
				var totalVideoTags = <?php echo $totalVideoTags; ?>;
				var loadedVideoTags = <?php echo $loadedVideoTags; ?>;
				var totalPeople = <?php echo $totalPeople; ?>;
				var loadedPeople = <?php echo $loadedPeople; ?>;

				var totalVideos = <?php echo $totalVideos; ?>;
				var loadedVideos = <?php echo $loadedVideos; ?>;

				// $(".loadMoreResult").click(function(){

				//tags 
				$(document).on('click', '#tagResult .loadMoreResult', function() {
					var type = $(this).attr('type');
					// if(totalVideoTags>loadedVideoTags){
					// $('.loadMore').show();
					tpage = tpage + 1;
					$.ajax({
						type: "GET",
						url: searchUrl,
						data: {
							page: tpage,
							type: type,
							search: '<?php echo $search; ?>'
						},
						dataType: "json",
						success: function(response) {
							if (response.html != '') {
								tpage = tpage;
								if (type == 'T') {
									totalVideoTags = response.totalVideoTags;
									loadedVideoTags = loadedVideoTags + response.loadedVideoTags;
									if (totalVideoTags <= loadedVideoTags) {
										$('#tagResult .loadMoreResult').hide();
									}
									// $('.loadMore').hide();
									$('#tagResult .moreTags').append(response.html);
								}

							}
						}
					});
				});

				//people
				$(document).on('click', '#peopleResult .loadMoreResult', function() {
					var type = $(this).attr('type');
					ppage = ppage + 1;
					$.ajax({
						type: "GET",
						url: searchUrl,
						data: {
							page: ppage,
							type: type,
							search: '<?php echo $search; ?>'
						},
						dataType: "json",
						success: function(response) {
							if (response.html != '') {
								ppage = ppage;

								if (type == 'P') {
									totalPeople = response.totalPeople;
									loadedPeople = loadedPeople + response.loadedPeople;
									if (totalPeople <= loadedPeople) {
										$('#peopleResult .loadMoreResult').hide();
									}
									$('.morePeople').append(response.html);
								}
							}
						}
					});
				});

				//videos
				$(document).on('click', '#videoResult .loadMoreResult', function() {
					var type = $(this).attr('type');
					vpage = vpage + 1;
					$.ajax({
						type: "GET",
						url: searchUrl,
						data: {
							page: vpage,
							type: type,
							search: '<?php echo $search; ?>'
						},
						dataType: "json",
						success: function(response) {
							if (response.html != '') {
								vpage = vpage;

								if (type == 'V') {
									totalVideos = response.totalVideos;
									loadedVideos = loadedVideos + response.loadedVideos;
									if (totalVideos <= loadedVideos) {
										$('#videoResult .loadMoreResult').hide();
									}
									$('.moreVideo').append(response.html);
								}
							}
						}
					});
				});
			<?php } ?>

			<?php if (Route::currentRouteName() == 'web.following-list' || Route::currentRouteName() == 'web.followers-list') { ?>

				<?php if (Route::currentRouteName() == 'web.following-list') { ?>
					var followingUrl = "{{route('web.following-list',['id'=> $userInfo->user_id])}}";
				<?php } else { ?>
					var followingUrl = "{{route('web.followers-list',['id'=> $userInfo->user_id])}}";
				<?php } ?>
				var page = 1;
				var totalFollow = <?php echo $totalFollow; ?>;
				var loadedFollow = <?php echo $loadedFollow; ?>;
				$(window).scroll(function() {

					if ($(window).scrollTop() == $(document).height() - $(window).height()) {
						if (totalFollow > loadedFollow) {
							$('.loadMore').show();
							page = page + 1;
							$.ajax({
								type: "GET",
								url: followingUrl,
								data: {
									page: page
								},
								dataType: "json",
								success: function(response) {
									if (response.html != '') {
										page = page;
										totalFollow = response.totalFollow;
										loadedFollow = loadedFollow + response.loadedFollow;
										$('.loadMore').hide();
										$('#follow').append(response.html);
									}
								}
							});
						}
					}
				});


			<?php } ?>

			<?php if (Route::currentRouteName() == 'web.blocked-user-list') { ?>
				var blockUrl = "{{route('web.blocked-user-list')}}";

				var page = 1;
				var totalBlock = <?php echo $totalBlock; ?>;
				var loadedBlock = <?php echo $loadedBlock; ?>;
				$(window).scroll(function() {

					if ($(window).scrollTop() == $(document).height() - $(window).height()) {
						if (totalBlock > loadedBlock) {
							$('.loadMore').show();
							page = page + 1;
							$.ajax({
								type: "GET",
								url: blockUrl,
								data: {
									page: page
								},
								dataType: "json",
								success: function(response) {
									if (response.html != '') {
										page = page;
										totalBlock = response.totalBlock;
										loadedBlock = loadedBlock + response.loadedBlock;
										$('.loadMore').hide();
										$('#block').append(response.html);
									}
								}
							});
						}
					}
				});


			<?php } ?>

		});

		var count = "{{$newNotificationCount}}";

		// home page 
		$(document).ready(function() {
			<?php if ((Route::currentRouteName() == 'web.home' && !request('explore'))) {
				?>
				// 	var page = 1;
				// 	var totalVideo = <?php echo $videosCount; ?>;
				// 	var loadedVideo = <?php echo config('app.videos_per_page'); ?>;
				// 	var videoFetchUrl = "{{route('web.home')}}";

				// 	$('video').each(function() {
				// 		this.pause();
				// 	});

				// 	var firstVideoId = $('.home-video video:first').attr('id');
				// 	const video = document.getElementById(firstVideoId);

				// 	// video.muted = false; // ✅ now safe
				// 	video.play().catch(err => console.warn("Play failed:", err));
	

				// let lastId = null;

				// $('#leukeVideos').on('scroll', $.debounce(100, function () {
				// 	let videoContainer = this;
				// 	let currentId = null;

				// 	$('#leukeVideos video').each(function() {
				// 		const rect = this.getBoundingClientRect();
				// 		const containerRect = videoContainer.getBoundingClientRect();

				// 		// Check if the video's middle point is within the container’s visible area
				// 		const videoMid = rect.top + rect.height / 2;

				// 		if (videoMid >= containerRect.top && videoMid <= containerRect.bottom) {
				// 			currentId = this.id;
				// 			return false; // break out of each loop
				// 		}
				// 	});

				// 	if (currentId && currentId !== lastId) {
				// 		console.log("Currently visible video ID:", currentId);
				// 		console.log("lastId video ID:", lastId);
				// 		lastId = currentId;
				// 		$('video').each(function() {
				// 			this.pause();
				// 		});
				// 		playVideo(currentId);
				// 	}
				// 	const $this = $(this);

				// 	const scrollTop = $this.scrollTop();
				// 	const scrollHeight = this.scrollHeight;
				// 	const containerHeight = $this.innerHeight();
				// 	if (scrollTop + containerHeight >= scrollHeight - 1) {
				// 		// User has scrolled to (or near) the bottom
				// 		// const lastDiv = $this.find('div:last'); // or any selector you expect
				// 		// const lastId = lastDiv.attr('id');

				// 		console.log("Reached bottom. Last div ID:", lastId);
				// 		isMuted=$('#'+lastId).prop('muted');
				// 		$('.loadMore').show();
				// 		page = page + 1;
				// 		$.ajax({
				// 			type: "GET",
				// 			url: videoFetchUrl,
				// 			data: {
				// 				page: page
				// 			},
				// 			dataType: "json",
				// 			success: function(response) {
				// 				if (response.html != '') {
				// 					page = page;
				// 					totalVideo = response.videosCount;
				// 					loadedVideo = loadedVideo + response.videos.length;
				// 					// alert(response.videos.data.length);

				// 					$('#leukeVideos').append(response.html);
				// 					$('video').prop('muted',isMuted);
				// 				}
				// 				$('.loadMore').hide();
				// 			}
				// 		});
				// 	}

				// }));
			<?php 
			} ?>

			var m_height = 80 + 54;
			var inner_height = $(window).height() - m_height;
			$('.h4-about').css('min-height', inner_height + 'px');
			$('.messenger').css('height', $(window).height() - 80 + 'px');

			sharedVideoId = "{{ $sharedVideoId ?? '' }}";
			sharedVideoSrc = "{{ $sharedVideoSrc ?? '' }}";
			if (sharedVideoId != '') {
				$('#LeukeModal').modal();
				modelbox_open(sharedVideoSrc, sharedVideoId);
			}

			if (count != 0) {
				$('.notification_count').html(count);
				$("#notification_count").fadeIn("slow");
			}
			$('.notification_close').click(function() {
				$(".notificationContainer").fadeOut("slow");
			});
			$(".notificationLink").click(function() {
				$(".notificationContainer").fadeToggle(300);
				$(".notification_count").fadeOut("slow");
				count = 0;

				//here call the controller to change status of the read
				url = "{{ route('web.notificationStatus') }}";
				img = "{{asset('default/notification_icon.png') }}";
				$.ajax({
					type: "GET",
					url: url,
					data: "",
					dataType: "json",
					success: function(response) {
						// alert('abc');
						if (response.notificationHtml == "") {
							$('.notificationsBody').html("<div class='row text-center'><div class='col-12 text-center'><img src ='" + img + "' width='85'></div><div class='col-12'><b>All Activity</b></div><div class='col-12'><p>Notification about your account will appear here</p></div></div>");
						} else {
							$('.notificationsBody').html(response.notificationHtml);
						}

					}
				});
				return false;
			});

			//Document Click hiding the popup 
			$(document).click(function() {
				$(".notificationContainer").hide();
			});

			//Popup on click
			$(".notificationContainer").click(function() {
				return false;
			});

		});

		function videoShare(link) {
			facebookLink = "{{ Share::page(':link', '')->facebook()->getRawLinks() }}";
			twitterLink = "{{ Share::page(':link', null)->twitter()->getRawLinks() }}";
			whatsappLink = "{{ Share::page(':link')->whatsapp()->getRawLinks() }}";
			facebookLink = facebookLink.replace(':link', link);
			twitterLink = twitterLink.replace(':link', link);
			whatsappLink = whatsappLink.replace(':link', link);

			htmlContent = "<div class='d-flex flex-row justify-content-around'><a href='" + facebookLink + "'><i class='fa fa-facebook-square fa-2x ml-2' aria-hidden='true'></i></a>" +
				"<a href='" + twitterLink + "'><i class='fa fa-twitter-square fa-2x ml-2' aria-hidden='true'></i></a>" +
				"<a href='" + whatsappLink + "'><i class='fa fa-whatsapp fa-2x ml-2 mb-2 mr-2' aria-hidden='true'></i></a>" +
				"</div>";
			$("#video-share").popover({
				// title: function() {
				// 	return '<h5 class="text-white">Share</h5>';
				// },
				placement: 'top',
				container: 'body',
				html: true,
				content: function() {
					return htmlContent;
				}
			});
			$("#video-share").popover('show');
		}

		$(document).on('submit','.modal-comment-form', function(e) {
			console.log('formmmmmmmmmm');
			e.preventDefault();
			form_data = $(this).serialize();
			formUrl = $(this).prop('action');
			that=$(this);
			$.ajax({
				url: formUrl,
				type: 'POST',
				datatype: 'json',
				data: form_data,
				success: function(data) {
					if (data.success) {
						that.find('.video_comment').val('');
						// $('#video_comment').val('');
						$('#no_comment').css('display', 'none');
						that.parents('.modal-right-section').find('.modal-comment-list').animate({
							scrollTop: that.parents('.modal-right-section').find('.modal-comment-list').prop("scrollHeight")
						}, 1000);
						videoComments('insert',that);
					}
				},
				error: function(data) {
					if (data.status == 401) {
						window.location.href = "{{ route('web.login') }}";
					}
				}
			});
		})

		$(document).on('click', '.follow_btn', function() {
			// $('.follow_btn').on('click',function(){
			var userId = $(this).attr('data-id');
			var cv = $(this);
			var url = "{{ route('web.followUnfollowUser', ':id') }}";
			url = url.replace(':id', userId);
			$.ajax({
				url: url,
				type: 'GET',
				datatype: 'json',
				success: function(data) {
					if (data.success) {
						if (data.follow) {
							cv.html('Unfollow');
						} else {
							cv.html('Follow');
						}
					}
				},
				error: function(data) {
					if (data.status == 401) {
						window.location.href = "{{ route('web.login') }}";
					}
				}
			});
		});


		$(document).on('click', '.home_follow_btn', function() {
			// $('.follow_btn').on('click',function(){
			var userId = $(this).attr('data-id');
			var cv = $(this);
			var url = "{{ route('web.followUnfollowUser', ':id') }}";
			url = url.replace(':id', userId);
			$.ajax({
				url: url,
				type: 'GET',
				datatype: 'json',
				success: function(data) {
					if (data.success) {
						if (data.follow) {
							html = '<i class="fa fa-check follow-icon"></i>';

						} else {
							html = '<i class="fa fa-plus follow-icon" ></i>';
						}

						cv.html(html);
					}
				},
				error: function(data) {
					if (data.status == 401) {
						window.location.href = "{{ route('web.login') }}";
					}
				}
			});
		});

		// $(document).on('click', '.delete-single-msg', function() {
		// 	msg_id = $(this).attr('data-id');
		// 	that = this;
		// 	$.ajax({
		// 		url: "{{-- route('web.deleteSingleMsg') --}}",
		// 		type: 'POST',
		// 		data: {
		// 			msg_id: msg_id,
		// 			"_token": "{!! csrf_token() !!}"
		// 		},
		// 		datatype: 'json',
		// 		success: function(data) {
		// 			if (data.status == true) {
		// 				$(that).parent().parent().parent().hide();
		// 			}
		// 		},
		// 		error: function(data) {
		// 			if (data.status == 401) {
		// 				window.location.href = "{{ route('web.login') }}";
		// 			}
		// 		}
		// 	});
		// });

		// 		function hoverVideo(id) {
		// 			$("#video_" + id).get(0).play();
		// 		}

		// 		function hideVideo(id) {
		// 			$("#video_" + id).get(0).pause();
		// 		}

		// let userHasInteracted = false;

		// document.getElementById("leukeVideos").click();
		// document.addEventListener("click", () => {
		userHasInteracted = true;
		// });



		function showIcon() {
			$('.ModelCtrlBtn').show();
		}

		function hideIcon() {
			$('.ModelCtrlBtn').hide();
		}

		$('#LeukeModal').on('hidden.bs.modal', function() {
			// $('#leukeVideo')[0].pause();
			$('video').each(function() {
						this.pause();
					});
		});
		window.document.onkeydown = function(e) {
			if (!e) {
				e = event;
			}
			if (e.keyCode == 27) {
				model_close();
			}
		}

		var checkThePlayheadPositionTenTimesASecond;
		var videoId = document.getElementById("leukeVideo");

		var pageNo = 5;
		var commentFormRoute = '';
		var morePages;
		var oldPage;
		var newPage;
		var bottom;

		// videoId.ontimeupdate = function() {myFunction()};

		function videoLike(vId) {
			vId = $('#video_id').val();
			var likeUrl = "{{ route('web.videoLike', ':id') }}";
			likeUrl = likeUrl.replace(':id', vId);
			$.ajax({
				url: likeUrl,
				type: 'GET',
				datatype: 'json',
				success: function(data) {
					if (data.success) {

						if (data.liked) {
							// $('#video-like').attr('src', '{{ asset("default/heart_img__r_icon.svg") }}');
							html = '<i class="fa fa-heart red" onclick="videoLike()"></i>';
						} else {
							// $('#video-like').attr('src', '{{ asset("default/heart_img_w_icon.svg") }}');
							html = '<i class="fa fa-heart" onclick="videoLike()"></i>';
						}
						html += '<p class="span-text"> ' + data.totalLikes + ' </p>';
						// $('#video_like_' + vId).html('<i class="fa fa-heart-o" aria-hidden="true"></i> ' + data.totalLikes);
						$('.home-like-' + vId).html(html);
						$('#video-like').html(html);
					}
				},
				error: function(data) {
					if (data.status == 401) {
						window.location.href = "{{ route('web.login') }}";
					}
				}
			});
		}

		$(document).on('click', '.home_like', function() {
			vId = $(this).attr('data-id');
			var likeUrl = "{{ route('web.videoLike', ':id') }}";
			likeUrl = likeUrl.replace(':id', vId);
			that = this;
			$.ajax({
				url: likeUrl,
				type: 'GET',
				datatype: 'json',
				success: function(data) {
					if (data.success) {
						if (data.liked) {
							html = '<i class="fa fa-heart red"></i>';
						} else {
							html = '<i class="fa fa-heart"></i>';
						}
						html += '<p class="span-text"> ' + data.totalLikes + ' </p>';
						$(that).html(html);
						// $('#video_like_' + vId).html('<i class="fa fa-heart-o" aria-hidden="true"></i> ' + data.totalLikes);
						// $('.home-like-' + vId).html('<img src="<?php echo asset('default/heart_img_w_icon.svg'); ?>" width="35px"><p class="span-text"> ' + data.totalLikes + ' </p> &nbsp; ');
					}
				},
				error: function(data) {
					if (data.status == 401) {
						window.location.href = "{{ route('web.login') }}";
					}
				}
			});
		})

		function openModal(id) {
			$('#' + id).trigger('click');
		}

		function modelbox_open(source, videoId, indexId) {
			oldPage = 1;
			newPage = 2;
			morePages = true;
			bottom = true;

			$("#modal-comment-list").html(' ');

			html = '<i class="fa fa-heart " onclick="videoLike()"></i>';
			html += '<p class="span-text"> 0 </p>';
			$('#video-like').html(html);

			// $('#video-like').attr('src', '{{ asset("default/heart_img_w_icon.svg") }}');
			// $('#video-like').removeClass('fa-heart');
			// $('#video-like').addClass('fa-heart-o');
			// $("#modal-comment-list").animate({scrollTop: $("#modal-comment-list").offset().top});



			var leukeVideo = document.getElementById("leukeVideo");
			leukeVideo.src = source;
			leukeVideo.play();

			checkThePlayheadPositionTenTimesASecond = setInterval(function() {
				myTimer(videoId);
			}, 1000);

			var vidUrl = "{{ route('web.videoInfo', ':id') }}";
			vidUrl = vidUrl.replace(':id', videoId);

			commentFormRoute = "{{ route('web.videoPostComments', ':id') }}";
			commentFormRoute = commentFormRoute.replace(':id', videoId);

			socialLink = "{{ utf8_decode(urldecode(route('open-video', ['video_id' => ':id']))) }}";
			socialLink = socialLink.replace(':id', videoId);

			userProfileUrl = "{{ route('web.userProfile', ':id') }}";

			$.ajax({
				url: vidUrl,
				type: 'GET',
				datatype: 'json',
				success: function(data) {
					// console.log('aaaaaaaaaaaaa');
					// console.log(data);
					proifleImg = '';
					var index = data.video.user_dp.indexOf('googleusercontent.com');
					var index2 = data.video.user_dp.indexOf('facebook.com');
					var index3 = data.video.user_dp.indexOf('fbsbx.com');
					// if(index !== -1){
					//     alert("Substring found!");
					// } else{
					//     alert("Substring not found!");
					// }
					if (index !== -1 || index2 !== -1 || index3 !== -1) {
						profileImg = data.video.user_dp;
					} else {
						profileImg = data.video.user_dp;
						// profileImg= profileImg.replace(':userId', data.video.user_id);
					}

					// if(data.comment_html==""){
					// 	$("#modal-video-comment").hide();
					// }

					if (data.video.wide ==1) {
						$('#LeukeModal .home-video').addClass('h-active-video video-section');
					} else {
						$('#LeukeModal .home-video').removeClass('h-active-video video-section');
					}

					$('#video_id').val(videoId);

					userProfileUrl = userProfileUrl.replace(':id', data.video.user_id);

					$("#user-profile-img").closest("a").attr('href', userProfileUrl);
					$('#user-profile-img').prop('src', profileImg);
					$('#user-profile-info').html(data.video.name);
					$('.video_user_name').html(data.video.username);
					if (data.video.verified == 'A') {
						$('.verified_account').show();
					} else {
						$('.verified_account').hide();
					}
					// alert(data.video.description);
					$('.video_title').html(data.video.description);
					$(".video_title").append('<br />' + data.hashtags);
					$('#modal-comment-list').html(data.comment_html);
					// $('#modal-total-views').html(data.video.total_views + ' Views');
					$('.modal_video_view').html('<i class="fa fa-eye"></i> ' + data.video.total_views);
					$('#modal-video-date').html(data.video.video_date);
					$('.follow_div').html(data.follow_html);
					$('#modal-comment-form').prop('action', commentFormRoute);
					$("#modal-comment-list").animate({
						scrollTop: $("#modal-comment-list").offset().top
					});
					// modal-video-comment
					if (data.userLikedVideo == true) {
						// $('#video-like').attr('src', '{{ asset("default/heart_img__r_icon.svg") }}');
						html = '<i class="fa fa-heart red" onclick="videoLike()"></i>';
						html += '<p class="span-text"> ' + data.video.total_likes + ' </p>';
						$('#video-like').html(html);

						// $('#video-like').removeClass('fa-heart-o');
						// $('#video-like').addClass('fa-heart');


					}


					$('#video-share').attr('onclick', "videoShare('" + socialLink + "')");

				}
			});

		}

		$("#modal-comment-list").scroll(function() {
			videoComments('scroll');
		});

		$(document).on('click', '.block_btn', function() {
			var userId = $(this).attr('data-id');
			var that = $(this);
			var url = "{{ route('web.blockUnblock', ':id') }}";
			url = url.replace(':id', userId);
			$.ajax({
				url: url,
				type: 'GET',
				datatype: 'json',
				success: function(data) {
					if (data.success) {
						if (data.block) {
							that.text('Unblock');
						} else {
							that.text('Block');
							// $('block_success').show();
							// setTimeout(() => {
							// 	$('block_success').hide();
							// }, 4000);
							// that.closest('.card').hide();
						}
					}
				},
				error: function(data) {
					if (data.status == 401) {
						window.location.href = "{{ route('web.login') }}";
					}
				}
			});

		});

		function blockUnblock(userId) {
			var url = "{{ route('web.blockUnblock', ':id') }}";
			url = url.replace(':id', userId);
			$.ajax({
				url: url,
				type: 'GET',
				datatype: 'json',
				success: function(data) {
					if (data.success) {
						if (data.block) {
							$('#blockUnblockIcon').html('<i class="fa fa-check-circle"></i>');
							$('#blockUnblock').html('Unblock');
						} else {
							$('#blockUnblockIcon').html('<i class="fa fa-ban"></i>');
							$('#blockUnblock').html('Block');
						}
					}
				},
				error: function(data) {
					if (data.status == 401) {
						window.location.href = "{{ route('web.login') }}";
					}
				}
			});
		}

		function followUnfollow(userId) {
			var url = "{{ route('web.followUnfollowUser', ':id') }}";
			url = url.replace(':id', userId);
			$.ajax({
				url: url,
				type: 'GET',
				datatype: 'json',
				success: function(data) {
					if (data.success) {
						if (data.follow) {
							$('#followUnfollowIcon').html('<i class="fa fa-user-times"></i>');
							$('#followUnfollow').html('Unfollow');
						} else {
							$('#followUnfollowIcon').html('<i class="fa fa-user-plus"></i>');
							$('#followUnfollow').html('Follow');
						}
					}
				},
				error: function(data) {
					if (data.status == 401) {
						window.location.href = "{{ route('web.login') }}";
					}
				}
			});
		}

		function homefollowUnfollow(userId) {
			var url = "{{ route('web.followUnfollowUser', ':id') }}";
			url = url.replace(':id', userId);
			$.ajax({
				url: url,
				type: 'GET',
				datatype: 'json',
				success: function(data) {
					if (data.success) {
						if (data.follow) {
							$('#followUnfollow').html('Unfollow');
						} else {
							$('#followUnfollow').html('Follow');
						}
					}
				},
				error: function(data) {
					if (data.status == 401) {
						window.location.href = "{{ route('web.login') }}";
					}
				}
			});
		}

		function videoComments(type,that) {
			canScroll = newPage > oldPage;
			// var elem = $('#modal-comment-list');
			var elem = that.parents('.modal-right-section').find('.modal-comment-list');
			bottom = (elem[0].scrollHeight - elem.scrollTop()) == elem.outerHeight();

			if ((morePages && canScroll && bottom) || type == 'insert') {
				oldPage = newPage;
				videoId = that.parents('.modal-right-section').attr('data-video-id');

				var vidUrl = "{{ route('web.videoComments',['type'=>':type','id'=>':id']) }}";
        		vidUrl = vidUrl.replace(':id', videoId);
				vidUrl = vidUrl.replace(':type', type);
		
				$.ajax({
					url: vidUrl,
					type: 'GET',
					datatype: 'json',
					success: function(data) {
						elem.append(data.comment_html);
						newPage++;
						morePages = data.morePages;
					}
				});

			}

		}

		function myTimer(vId) {
			if (!videoId.paused) {
				var ctime = videoId.currentTime;
				if (ctime >= 5) { //alert('abc');
					//send ajax request for views increment
					var vidUrl = "{{ route('web.videoViewed', ':id') }}";
					var cookie = "{{ Illuminate\Support\Facades\Cookie::get('videoViewed') }}";

					vidUrl = vidUrl.replace(':id', vId);
					$.ajax({
						url: vidUrl,
						type: 'GET',
						datatype: 'json',
						data: {
							'unique_token': cookie,
						},
						success: function(data) {
							clearInterval(checkThePlayheadPositionTenTimesASecond);
							$('#video_view_' + vId).html('<i class="fa fa-eye"></i> ' + data.total_views);
						}
					});

					clearInterval(checkThePlayheadPositionTenTimesASecond);
				}
			}
		}

		function model_close() {
			// location.reload();
			var leukeVideo = document.getElementById("leukeVideo");
			leukeVideo.pause();

			$('#video_id').val('');
			$('#user-profile-img').prop('src', '');
			$('#user-profile-info').html(' ');
			$('#modal-comment-list').html(' ');
			$('#modal-total-views').html(' ');
			$('#modal-video-date').html(' ');
			$('#modal-comment-form').prop('action', '');
			$('#video-like').removeClass('fa-heart');
			$('#video-like').addClass('fa-heart-o');
			$('.modal_video_view').html(' ');
			$('.follow_div').html('');
		}

		function myFunction() {}

		$('body').on('click', function(e) {
			$('[data-toggle=popover]').each(function() {
				// hide any open popovers when the anywhere else in the body is clicked
				if (!$(this).is(e.target) && $(this).has(e.target).length === 0 && $('.popover').has(e.target).length === 0) {
					$(this).popover('hide');
				}
			});
		});

		// $(window).on('scroll', function() {
		// 	$('.video-container').each(function() {
		// 		let containerTop = $(this).offset().top;
		// 		let containerBottom = containerTop + $(this).outerHeight();
		// 		let scrollTop = $(window).scrollTop();
		// 		let windowHeight = $(window).height();

		// 		let $video = $(this).find('video');

		// 		if (scrollTop + windowHeight >= containerBottom) {
		// 			// Stick to bottom
		// 			$video.css({
		// 				top: 'auto',
		// 				bottom: '0'
		// 			});
		// 		} else if (scrollTop >= containerTop) {
		// 			// Stick to top
		// 			$video.css({
		// 				top: '0',
		// 				bottom: 'auto'
		// 			});
		// 		} else {
		// 			// Reset
		// 			$video.css({
		// 				top: '',
		// 				bottom: ''
		// 			});
		// 		}
		// 	});
		// });


		function changeStatus() {
			$.ajax({
				type: "GET",
				url: "{{ route('web.notificationStatus', ['type' => 'All']) }}",
				dataType: "json",
				success: function(response) {
					// alert('abc');
					$('.notificationBlock').css('background', 'white');
				},
				error: function(data) {
					if (data.status == 401) {
						window.location.href = "{{ route('web.login') }}";
					}
				}
			});
		}

		$(function() {
			$("#leuke_search").autocomplete({
				source: function(request, response) {
					$.ajax({
						url: "{{ route('web.leukeSearch') }}",
						dataType: "json",
						data: {
							term: $('#leuke_search').val(),
						},
						success: function(data) {
							response($.map(data.result, function(result) {
								return {
									label: result.label,
									imgSrc: result.imgSrc,
									url: result.url,
								}
							}));
						}
					});
				},
				minLength: 1,
				select: function(event, ui) {
					window.location.href = ui.item.url;
				},
			}).data("ui-autocomplete")._renderItem = function(ul, item) {
				return $("<li></li>")
					.data("item.autocomplete", item)
					.append("<a>" + "<img style='width:30px;height:30px' src='" + item.imgSrc + "' /><span class='pl-3'>" + item.label + "</span></a>")
					.appendTo(ul);
			};
		});
		$(function() {
			if ($('.alert-section').is(':visible')) {
				setTimeout(function() {
					$(".alert-section").hide('blind', {}, 800)
				}, 5000);
			}
		});

		$(document).on('click','.show_more',function(){
			desc=$(this).attr('data-desc');
			$(this).prev('.desc').html(desc);
			$(this).html('show less').addClass('show_less').removeClass('show_more');
			
			// $(this).parents('.title_div').animate({
			// 	bottom:'12px',
			// },300)
		});

		$(document).on('click','.show_less',function(){
  			desc=$(this).prev('.desc').html();
  			shortDesc = desc.substring(0, 100);

			$(this).prev('.desc').html(shortDesc + '...');
			$(this).html('show more').addClass('show_more').removeClass('show_less');
		});

	</script>
	<script data-cfasync="false" src="{{ asset('js/email-decode.min.js?v=').$version }}"></script>
	<script src="{{ asset('js/jquery.easing.min.js?v=').$version }}"></script>
	<script src="{{ asset('js/popper.min.js?v=').$version }}"></script>
	<script src="{{ asset('js/waypoints.min.js?v=').$version }}"></script>
	<!--<script src="{{ asset('js/bootstrap.min.js?v=').$version }}"></script>-->
	<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/js/bootstrap.min.js"></script>
	<script src="{{ asset('js/swiper.min.js?v=').$version }}"></script>
	<script src="{{ asset('js/jquery.events.touch.min.js?v=').$version }}"></script>
	<script src="{{ asset('js/lightcase.js?v=').$version }}"></script>
	<script src="{{ asset('js/jquery.counterup.min.js?v=').$version }}"></script>
	<script src="{{ asset('js/TweenMax.min.js?v=').$version }}"></script>
	<script src="{{ asset('js/jquery.wavify.js?v=').$version }}"></script>
	<script src="{{ asset('js/wow.min.js?v=').$version }}"></script>
	<script src="{{ asset('js/jquery.parallax-scroll.js?v=').$version }}"></script>
	<script src="{{ asset('js/particles.min.js?v=').$version }}"></script>
	<script src="{{ asset('js/jarallax.min.js?v=').$version }}"></script>
	<script src="{{ asset('js/jarallax-video.min.js?v=').$version }}"></script>
	<script src="{{ asset('js/form-validator.js?v=').$version }}"></script>
	<script src="{{ asset('js/custom.js?v=').$version }}"></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js"></script>
	<script src="{{ asset('js/sweetalert.min.js') }}"></script>


	<script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js" integrity="sha512-bPs7Ae6pVvhOSiIcyUClR7/q2OAsRiovw4vAkX+zJbw3ShAeeqezq50RIIcIURq7Oa20rW2n2q+fyXBNcU9lrw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
	<script type="text/javascript">
		$('.owl-carousel').owlCarousel({
			loop: false,
			margin: 10,
			nav: true,
			navText: ["<div class='nav-btn prev-slide'></div>", "<div class='nav-btn next-slide'></div>"],
			responsive: {
				0: {
					items: 1
				},
				360: {
					items: 5
				},
				400: {
					items: 5
				},
				600: {
					items: 5
				},
				1000: {
					items: 7
				}
			}
		});
	</script>

</body>

</html>