	<script src="{{ asset('js/debounce.min.js') }}"></script>
	<script type="text/javascript">
	  $(document).ready(function() {
	    let videos = [];
	    page = 1;
	    // var lastElement = $('.video-item').last();
	    // Get video list
	    $('.video-item').each(function() {
	      videos.push({
	        url: $(this).data('url'),
	        id: $(this).data('id')
	      });
	    });

	    // On video click, open modal and append videos
	    $(document).on('click', '.video-item', function() {
	      const clickedIndex = $(this).data('id');
	      currentIndex = $(this).index();
	      $('#LeukeModal .modal-body').append('<div class="videoMoveCtrl"><i class="fa fa-angle-up up"></i><i class="fa fa-angle-down down"></i></div>');
	      // console.log(currentIndex);
	      setTimeout(() => {
	        document.getElementById(`video-${clickedIndex}`).scrollIntoView({
	          behavior: 'auto'
	        });

	        commentSectionWidth = $('.comment-section').width();
	        commentSectionWidth = commentSectionWidth + 50;
	        $('.videoMoveCtrl').css('right', commentSectionWidth + 'px');
	        // console.log('update arrow--------');
	        updateArrows();
	      }, 500);

	    });


	    <?php if (Route::currentRouteName() == 'web.home' && !request('explore')) { ?>

	      const vidContainer = document.getElementById('videoContainer');
	      const options = {
	        root: vidContainer,
	        rootMargin: '0px',
	        threshold: 0.5 // Trigger when at least 50% of video is visible
	      };

	      let currentVisibleId = null;
	      totalMVideo = "{{ $videosCount }}";
	      loadedMVideo = "{{ $videos->count() }}";

	      const observer = new IntersectionObserver((entries) => {
	        entries.forEach(entry => {
	          if (entry.isIntersecting) {

	            pauseAllVideos();

	            const element = entry.target;
	            currentVisibleId = element.id;
	            videoId = element.dataset.videoId;
	            // console.log(videoId);

	            $('#video' + videoId).get(0).play();
	            // get comments
	            var vidUrl = "{{ route('web.videoComments',['type'=>'scroll','id'=>':id']) }}";
	            vidUrl = vidUrl.replace(':id', videoId);

	            $.ajax({
	              url: vidUrl,
	              type: 'GET',
	              datatype: 'json',
	              success: function(data) {
	                // console.log('home only');
	                $('#video-' + videoId).parents('.row').find('.modal-comment-list').html(data.comment_html);
	                // $('#modal-total-views').html(data.video.total_views + ' Views');
	                // $('#'+currentVisibleId+' .modal_video_view').html('<i class="fa fa-eye"></i> ' + data.video.total_views);
	                // $('#modal-video-date').html(data.video.video_date);
	                $('#video-' + videoId).parents('.row').find('.follow_div').html(data.follow_html);
	                // $('#'+currentVisibleId+' .modal-comment-form').prop('action', commentFormRoute);
	                $('#video-' + videoId).parents('.row').find('.modal-comment-list').animate({
	                  scrollTop: $('#video-' + videoId).parents('.row').find('.modal-comment-list').offset().top
	                });
	              }
	            })
	            // end get comments

	            lastVideoId = $('#videoContainer .video').last().attr('id');

	            if (lastVideoId == currentVisibleId) {
	              $('.videoMoveCtrl .down').removeClass('fa-angle-down').addClass('fa-spinner');
	              page = page + 1;
	              url = "{{ route('web.home') }}";
	              $.ajax({
	                type: "GET",
	                url: url,
	                data: {
	                  page: page
	                },
	                dataType: "json",
	                success: function(response) {

	                  if (response.html != '') {
	                    $('.videoMoveCtrl .down').removeClass('fa-spinner').addClass('fa-angle-down').css('visibility', 'visible');
	                    page = page;
	                    // totalExVideo = response.totalVideo;
	                    loadedMVideo = loadedMVideo + response.loadedVideo;
	                    $('.loadMore').hide();
	                    $('#leukeVideos').append(response.html);
	                    $('#videoContainer').append(response.modalHtml);

	                    isMuted = $('#video' + lastVideoId).prop('muted');
	                    $('video').prop('muted', isMuted);

	                    document.querySelectorAll('#videoContainer .video').forEach(el => {
	                      observer.observe(el);
	                    });
	                  } else {
	                    $('.videoMoveCtrl .down').removeClass('fa-spinner').addClass('fa-angle-down').css('visibility', 'hidden');
	                  }
	                }
	              });
	            }
	            // console.log('Currently in view:', currentVisibleId);
	          }
	        });
	      }, options);

	      document.querySelectorAll('#videoContainer .video').forEach(el => {
	        observer.observe(el);
	      });


	      var page = 1;
	      var totalVideo = <?php echo $videosCount; ?>;
	      var loadedVideo = <?php echo config('app.videos_per_page'); ?>;
	      var videoFetchUrl = "{{route('web.home')}}";

	      $('video').each(function() {
	        this.pause();
	      });

	      var firstVideoId = $('.home-video video:first').attr('id');
	      const video = document.getElementById(firstVideoId);

	      // video.muted = false; 
	      video.play().catch(err => console.warn("Play failed:", err));


	      let lastId = $('#leukeVideos video').last().attr('id');

        let isLoading = false;

        $('#leukeVideos').on('scroll', debounce(function () {
            let container = $(this);
            let scrollTop = container.scrollTop();
            let scrollHeight = container[0].scrollHeight;
            let containerHeight = container.height();
        // if (!isLoading && scrollTop + containerHeight >= scrollHeight - 100) {
          isLoading = true;
	        let videoContainer = this;
	        let currentId = null;

	        $('#leukeVideos video').each(function() {
	          const rect = this.getBoundingClientRect();
	          const containerRect = videoContainer.getBoundingClientRect();

	          // Check if the video's middle point is within the container’s visible area
	          const videoMid = rect.top + rect.height / 2;

	          if (videoMid >= containerRect.top && videoMid <= containerRect.bottom) {
	            currentId = this.id;
	            return false; // break out of each loop
	          }
	        });
	        // console.log("lastId video ID:", lastId);
	        if (currentId && currentId !== lastId) {
	          // console.log("Currently visible video ID:", currentId);

	          // lastId = currentId;
	          $('video').each(function() {
	            this.pause();
	          });
	          playVideo(currentId);
	        }
	        const $this = $(this);

	        // const scrollTop = $this.scrollTop();
	        // const scrollHeight = this.scrollHeight;
	        // const containerHeight = $this.innerHeight();
	        if (lastId && currentId == lastId) {
	   
	          // console.log("Reached bottom. Last div ID:", lastId);
	          isMuted = $('#' + lastId).prop('muted');
	          $('.loadMore').show();
	          page = page + 1;
	          $.ajax({
	            type: "GET",
	            url: videoFetchUrl,
	            data: {
	              page: page
	            },
	            dataType: "json",
	            success: function(response) {
	              if (response.html != '') {
	                page = page;
	                totalVideo = response.videosCount;
	                loadedVideo = loadedVideo + response.videos.length;
	                // alert(response.videos.data.length);
	                // console.log('html response');
	                $('#leukeVideos').append(response.html);
	                $('#videoContainer').append(response.modalHtml);
	                mutedAction(isMuted);
	                document.querySelectorAll('#videoContainer .video').forEach(el => {
	                  observer.observe(el);
	                });

                  lastId = $('#leukeVideos video').last().attr('id');
	              } else {
	                lastId = null;
	              }
	              $('.loadMore').hide();
	                isLoading = false;
	            }
	          });
	        }
        // }
	      }));

	    <?php } ?>
	  });
    function debounce(func, delay) {
      let timeout;
      return function () {
        const context = this;
        const args = arguments;
        clearTimeout(timeout);
        timeout = setTimeout(() => func.apply(context, args), delay);
      };
    }

	  function pauseAllVideos() {
	    document.querySelectorAll('video').forEach(video => video.pause());
	  }


	  $(document).on('click', '.ModelSpeakerBtn', function() {
	    const $wrapper = $(this).closest('.home-video');
	    const $video = $wrapper.find('video').get(0);
	    const $icon = $(this).find('.spkIcon');

	    if ($video) {
	      $video.muted = !$video.muted;

	      // Toggle icon
	      if ($video.muted) {
	        $icon.removeClass('fa-volume-up').addClass('fa-volume-off');
	      } else {
	        $icon.removeClass('fa-volume-off').addClass('fa-volume-up');
	      }
	    }
	  });

	  // explore
	  <?php if ((Route::currentRouteName() == 'web.home' && request('explore'))  || Route::currentRouteName() == 'web.userProfile' || Route::currentRouteName() == 'web.searchAll'
      || Route::currentRouteName() == 'web.tagVideos'
    ) { ?>

	    const vidContainer = document.getElementById('videoContainer');
	    const options = {
	      root: vidContainer,
	      rootMargin: '0px',
	      threshold: 0.5 // Trigger when at least 50% of video is visible
	    };

	    var page = 1;
	    var totalExVideo = <?php echo $videosCount; ?>;
	    var loadedExVideo = <?php echo $videos->count(); ?>;
	    const observer = new IntersectionObserver((entries) => {
	      entries.forEach(entry => {
	        if (entry.isIntersecting) {

	          pauseAllVideos();

	          const element = entry.target;
	          currentVisibleId = element.id;
	          videoId = element.dataset.videoId;
	          // console.log(videoId);
	          // console.log('videoId');

	          $('#video' + videoId).get(0).play();
	          // get comments
	          var vidUrl = "{{ route('web.videoComments',['type'=>'scroll','id'=>':id']) }}";
	          vidUrl = vidUrl.replace(':id', videoId);

	          $.ajax({
	            url: vidUrl,
	            type: 'GET',
	            datatype: 'json',
	            success: function(data) {
	              // console.log('explore and user');
	              $('#video-' + videoId).parents('.row').find('.modal-comment-list').html(data.comment_html);
	              // $('#modal-total-views').html(data.video.total_views + ' Views');
	              // $('#'+currentVisibleId+' .modal_video_view').html('<i class="fa fa-eye"></i> ' + data.video.total_views);
	              // $('#modal-video-date').html(data.video.video_date);
	              $('#video-' + videoId).parents('.row').find('.follow_div').html(data.follow_html);
	              // $('#'+currentVisibleId+' .modal-comment-form').prop('action', commentFormRoute);
	              $('#video-' + videoId).parents('.row').find('.modal-comment-list').animate({
	                scrollTop: $('#video-' + videoId).parents('.row').find('.modal-comment-list').offset().top
	              });
	            }
	          })
	          // end get comments
	          lastVideoId = $('#videoContainer .video').last().attr('id');
	          // console.log('lastVideoId ' + videoId);
	          isMuted = $('#video' + videoId).prop('muted');
	          // console.log('isMuted ' + isMuted);

	          if (lastVideoId == currentVisibleId) {
	            $('.videoMoveCtrl .down').removeClass('fa-angle-down').addClass('fa-spinner');
	            page = page + 1;
	            url = "{{ route('web.home') }}?explore=true";
	            <?php if (Route::currentRouteName() == 'web.userProfile' && isset($userInfo)) { ?>
	              url = "{!! route('web.userProfile',$userInfo->user_id) !!}";
	            <?php } else if (Route::currentRouteName() == 'web.tagVideos') { ?>
	              url = "{!! route('web.tagVideos',['val'=>$search]) !!}";
	            <?php } else if (Route::currentRouteName() == 'web.searchAll') { ?>
	              url = "{!! route('web.searchAll',['search'=>$search,'type'=>'V']) !!}";
	            <?php } else { ?>
	              url = "{{ route('web.home') }}?explore=true";
	            <?php } ?>
	            // console.log('url ' + url);
	            $.ajax({
	              type: "GET",
	              url: url,
	              data: {
	                page: page
	              },
	              dataType: "json",
	              success: function(response) {
	                if (response.html != '') {
	                  $('.videoMoveCtrl .down').removeClass('fa-spinner').addClass('fa-angle-down').css('visibility', 'visible');
	                  page = page;
	                  // totalExVideo = response.totalVideo;
	                  loadedExVideo = loadedExVideo + response.loadedVideo;
	                  $('.loadMore').hide();
	                  $('#leukeVideos1').append(response.profileHtml);
	                  $('#videoContainer').append(response.html);
	                  // $('video').prop('muted',isMuted);
	                  mutedAction(isMuted);

	                  document.querySelectorAll('#videoContainer .video').forEach(el => {
	                    observer.observe(el);
	                  });
	                } else {
	                  $('.videoMoveCtrl .down').removeClass('fa-spinner').addClass('fa-angle-down').css('visibility', 'hidden');
	                }
	              }
	            });
	          }
	          // console.log('Currently in view:', currentVisibleId);
	        }
	      });
	    }, options);

	    document.querySelectorAll('#videoContainer .video').forEach(el => {
	      observer.observe(el);
	    });

	    $(window).scroll(function() {
	      if ($(window).scrollTop() == $(document).height() - $(window).height()) {
	        // console.log('loadedExVideo ' + totalExVideo);
	        // console.log('loadedExVideo ' + loadedExVideo);
	        if (totalExVideo > loadedExVideo) {
	          lastVideoId = $('video').last().attr('id');
	          // console.log('lastVideoId '+lastVideoId);
	          isMuted = $('#' + lastVideoId).prop('muted');
	          // console.log('isMuted '+isMuted);
	          <?php if (Route::currentRouteName() == 'web.userProfile' && isset($userInfo)) { ?>
	            scrollUrl = "{!! route('web.userProfile',$userInfo->user_id) !!}";
	          <?php } else if (Route::currentRouteName() == 'web.tagVideos') { ?>
	            scrollUrl = "{!! route('web.tagVideos',['val'=>$search]) !!}";
	          <?php } else if (Route::currentRouteName() == 'web.searchAll') { ?>
	            scrollUrl = "{!! route('web.searchAll',['search'=>$search,'type'=>'V']) !!}";
	          <?php } else { ?>
	            scrollUrl = "{{ route('web.home') }}?explore=true";
	          <?php } ?>
	          // console.log('scrollUrl ' + scrollUrl);
	          $('.loadMore').show();
	          page = page + 1;
	          $.ajax({
	            type: "GET",
	            url: scrollUrl,
	            data: {
	              page: page
	            },
	            dataType: "json",
	            success: function(response) {
	              if (response.html != '') {
	                page = page;
	                // totalExVideo = response.totalVideo;
	                loadedExVideo = loadedExVideo + response.loadedVideo;
	                $('.loadMore').hide();
	                $('#leukeVideos1').append(response.profileHtml);
	                $('#videoContainer').append(response.html);
	                mutedAction(isMuted);
	                document.querySelectorAll('#videoContainer .video').forEach(el => {
	                  observer.observe(el);
	                });
	              }
	            }
	          });
	        }
	      }
	    });
	  <?php } ?>

	  $(function() {
	    $('video').on('volumechange', function() {
	      var isMuted = $(this).prop('muted');
	      mutedAction(isMuted);
	    });
	  });

	  function mutedAction(isMuted) {
	    $('video').each(function() {
	      $(this).prop('muted', isMuted);
	    });

	    if (isMuted) {
	      $('#LeukeModal video').each(function() {
	        $(this).parents('.video').find('.spkIcon').removeClass('fa-volume-up').addClass('fa-volume-off');
	      });
	    } else {
	      $('#LeukeModal video').each(function() {
	        $(this).parents('.video').find('.spkIcon').removeClass('fa-volume-off').addClass('fa-volume-up');
	      });
	    }
	  }

	  function playVideo(id) {
	    $('video').each(function() {
	      this.pause();
	    });
	    const video = document.getElementById(id);
	    video.play();
	  }

	  function modelVideo(id) {
	    myVideo = document.getElementById(id);
	    if (myVideo.paused) {
	      // $('video').pause();
	      myVideo.play();
	      $('#' + id).parents('.home-video').find('.ctrlIcon').removeClass('fa-play').addClass('fa-pause');
	      // ppbutton.innerHTML = "Pause";
	    } else {
	      myVideo.pause();
	      $('#' + id).parents('.home-video').find('.ctrlIcon').removeClass('fa-pause').addClass('fa-play');
	      // ppbutton.innerHTML = "Play";
	    }
	  }


	  const container = document.getElementById('videoContainer');
	  let rowHeight = window.innerHeight;

	  function updateArrows() {
	    const upBtn = document.querySelector('.up');
	    const downBtn = document.querySelector('.down');

	    // Exit early if either button doesn't exist yet
	    if (!upBtn || !downBtn) {
	      console.warn('Arrow buttons not found yet.');
	      return;
	    }

	    const maxScroll = container.scrollHeight - container.clientHeight;
	    // console.log('maxScroll ' + maxScroll);
	    // console.log('scrollTop ' + container.scrollTop);

	    upBtn.style.visibility = container.scrollTop > 9 ? 'visible' : 'hidden';
	    downBtn.style.visibility = container.scrollTop < maxScroll ? 'visible' : 'hidden';
	  }

	  container.addEventListener('scroll', updateArrows);

	  window.addEventListener('resize', () => {
	    rowHeight = window.innerHeight;
	  });

	  $(document).on('click', '.up', function() {
	    container.scrollBy({
	      top: -rowHeight,
	      behavior: 'smooth'
	    });
	  });

	  $(document).on('click', '.down', function() {
	    container.scrollBy({
	      top: rowHeight,
	      behavior: 'smooth'
	    });
	  });


	  // This will work even after HTML is dynamically inserted
	  document.addEventListener('click', function(e) {
	    // Clicked on share button
	    if (e.target.closest('.share-btn')) {
	      e.stopPropagation();

	      const button = e.target.closest('.share-btn');
	      const id = button.getAttribute('data-id');
	      const popover = document.getElementById('popover-' + id);

	      // Hide all other popovers
	      document.querySelectorAll('.popover-content').forEach(p => p.style.display = 'none');

	      // Toggle the clicked one
	      if (popover.style.display === 'block') {
	        popover.style.display = 'none';
	      } else {
	        popover.style.display = 'block';
	      }
	    } else {
	      // Clicked outside any share button: hide all
	      document.querySelectorAll('.popover-content').forEach(p => p.style.display = 'none');
	    }
	  });

	  // Prevent closing popover when clicking inside it
	  document.addEventListener('click', function(e) {
	    if (e.target.closest('.popover-content')) {
	      e.stopPropagation();
	    }
	  });
	</script>