<div class="mob-left">
	<div class="row">
		<div class="col-12 text-center mb-4">
			<a href="{{ route('web.home') }}">
				<img class="mob-logo my-3" src="<?php

												use App\Helpers\Common\Functions;

												echo MyFunctions::getLogo(); ?>" alt="" width="45px">
			</a>
		</div>

		<div class="col-12">
			<div class="left-item">
				<a class="{{ (Route::currentRouteName() == 'web.home' && !request('explore')) ? 'active' : '' }}" href="{{ route('web.home') }}">
					<i class="fa fa-home"></i>
				</a>
			</div>

			<div class="left-item">
				<a class="{{ (Route::currentRouteName() == 'web.home' && request('explore')) ? 'active' : '' }}" href="{{ route('web.home') }}?explore=true">
					<i class="fa fa-compass"></i>
				</a>
			</div>
			<div class="left-item">
				<a href="{{ route('web.userNotifications') }}" class="{{ (Route::currentRouteName() == 'web.userNotifications') ? 'active' : '' }}">
					<i class="fa fa-bell"></i>
				</a>
			</div>

			<div class="left-item">
				<a class="{{ (Route::currentRouteName() == 'web.uploadVideo') ? 'active' : '' }}" href="{{ route('web.uploadVideo') }}">
					<i class="fa fa-cloud-upload"></i></a>
			</div>

			@if (auth()->guard('web')->check())
			<div class="left-item">
				<a class="{{ (Route::currentRouteName() == 'web.userProfile' || Route::currentRouteName() == 'web.followers-list' || Route::currentRouteName() == 'web.following-list') ? 'active' : '' }}" href="{{ route('web.userProfile',auth()->user()->user_id) }}">
					<i class="fa fa-user"></i></a>
			</div>
			@else
			<div class="left-item">
				<a href="{{ route('web.login') }}">
					<i class="fa fa-user"></i></a>
			</div>
			@endif
			<div class="left-item">
				<a class="{{ (Route::currentRouteName() == 'web.messages' || Route::currentRouteName() =='web.messages.chat') ? 'active' : '' }}" href="{{ route('web.messages') }}">
					<i class="fa fa-comments"></i></a>
			</div>
			@if (!auth()->guard('web')->check())

			<div class="left-item">
				<a class="" href="{{ route('web.login') }}">
					<i class="fa fa-sign-in"></i></a>
			</div>
			@endif
			@if (auth()->guard('web')->check())

			<div class="left-item">
				<a class="" href="{{ route('web.logout') }}">
					<i class="fa fa-sign-in"></i></a>
			</div>
			@endif
		</div>
	</div>
</div>
<div class="right-bar pl-2">
	<div class="row">
		<div class="col-12">
			<a href="{{ route('web.home') }}" class="d-block">
				<img class="white-logo img-responsive" src="<?php echo MyFunctions::getFrontLogo(); ?>" alt="">
			</a>

			<div class="video-search">
				<form action="{{ route('web.searchAll') }}" method="get">
					{{ csrf_field() }}
					<!-- <input type="text" class="v-search" placeholder="Search.." name="search" id="leuke_search" required> -->
					<!-- <input type="submit" class="" value="search">  -->
					<!-- <button type="submit" class="search-btn"><i class="fa fa-search"></i></button> -->

					<div class="search-container">
						<i class="fa fa-search search-icon"></i>
						<input type="text" class="v-search ui-autocomplete-input" placeholder="Search.." name="search" id="leuke_search" required autocomplete="off">
					</div>

				</form>
			</div>


			<div class="left-menu">

				<div class="left-item">
					<a class="{{ (Route::currentRouteName() == 'web.home' && !request('explore')) ? 'active' : '' }}" href="{{ route('web.home') }}">
						<i class="fa fa-home"></i> Home
					</a>
				</div>
				<div class="left-item">
					<a class="{{ (Route::currentRouteName() == 'web.home' && request('explore')) ? 'active' : '' }}" href="{{ route('web.home') }}?explore=true">
						<i class="fa fa-compass"></i> Explore
					</a>
				</div>
				<!-- if (auth()->guard('web')->check()) -->
				<div class="left-item">
					<a href="{{ route('web.userNotifications') }}" class="{{ (Route::currentRouteName() == 'web.userNotifications') ? 'active' : '' }}">
						<i class="fa fa-bell"></i> Notifications
					</a>
				</div>
				<!-- endif -->

				<div class="left-item">
					<a href="{{ route('web.uploadVideo') }}" class="{{ (Route::currentRouteName() == 'web.uploadVideo') ? 'active' : '' }}">
						<i class="fa fa-cloud-upload"></i> Upload</a>
				</div>
				@if (!auth()->guard('web')->check())

				<div class="left-item">
					<a class="" href="{{ route('web.login') }}">
						<i class="fa fa-user"></i> Profile</a>
				</div>
				@else
				<div class="left-item">
					<a class="{{ ((Route::currentRouteName() == 'web.userProfile' 
					|| Route::currentRouteName() == 'web.followers-list' 
					|| Route::currentRouteName() == 'web.following-list')
					&& ( isset(auth()->user()->user_id) && auth()->user()->user_id == $userInfo->user_id ) ) ? 'active' : '' }}" href="{{ route('web.userProfile',auth()->user()->user_id) }}">
						<i class="fa fa-user"></i> Profile</a>
				</div>
				@endif

				<div class="left-item">
					<a class="{{ (Route::currentRouteName() == 'web.messages' || Route::currentRouteName() =='web.messages.chat') ? 'active' : '' }}" href="{{ route('web.messages') }}">
						<i class="fa fa-comments"></i> Messages</a>
				</div>
				@if (auth()->guard('web')->check())
				<div class="left-item">
					<a class="" href="{{ route('web.logout') }}">
						<i class="fa fa-sign-in"></i> Logout</a>
				</div>
				@else

				<div class="left-item">
					<a class="" href="{{ route('web.login') }}">
						<i class="fa fa-sign-in"></i> Login</a>
				</div>
				@endif
			</div>
		</div>
	</div>
	<hr />
	<div class="row ">
		<?php $records = MyFunctions::getSuggestionAccount();
		if (count($records) > 0) { ?>
			<div class="col-xl-12 col-lg-12 col-md-12  col-12 video-rightbar-main">
				<div class="row">
					<div class="col-xl-12 col-lg-12 col-md-12  col-12">
						<h3 class="text-black">Suggestions for you</h3>
					</div>

					<?php
					foreach ($records as $res) { ?>
						<div class="col-xl-12 col-lg-12 col-md-12  col-12">
							<div class="video-profile-tab text-left">
								<?php
								if ($res->user_dp != "") {
									if (strpos($res->user_dp, 'facebook.com') !== false || strpos($res->user_dp, 'fbsbx.com') !== false || strpos($res->user_dp, 'googleusercontent.com') !== false) { ?>
										<img src="<?php echo $res->user_dp; ?>" alt="" />
									<?php } else {
									?>
										<img src="<?php echo asset(Storage::url('public/profile_pic/' . $res->user_id . '/small/' . $res->user_dp)); ?>" alt="" />

									<?php
									}
								} else { ?>
									<img src="<?php echo asset('default/default.png'); ?>" alt="" />
								<?php }  ?>
								<a class="pjax" href="{{ route('web.userProfile', $res->user_id) }}">
									<h5 class="small" style="display:inline-block">{{$res->fname}} {{$res->lname}}</h5>
								</a>
								<span class="follow_btn float-right" data-id="<?php echo $res->user_id; ?>" style="{{MyFunctions::getTopbarColor()}}">
									<?php if ($res->follow > 0) {
										echo "Unfollow";
									} else {
										echo "Follow";
									} ?>
								</span>
								<h5>@<?php echo $res->username; ?>
									<?php if ($res->verified == 'A') { ?>
										<img src="{{ asset('default/verified-icon-blue.png') }}" alt="" style="width:15px;height:15px;float:revert">
									<?php } ?>
								</h5>

							</div>
						</div>
					<?php } ?>

				</div>
			</div>
			<hr />
		<?php } ?>
	</div>
	{{-- <div class="row">

		<?php $sponsors_res = MyFunctions::getSponsors();
		if (count($sponsors_res) > 0) {
			foreach ($sponsors_res as $sponsor) {
		?>
		<a href="<?php echo $sponsor->url; ?>" class="text-black">
			<div class="col-xl-8 col-lg-8 col-md-8  col-md-8  video-rightbar-main">
				<h3 class="text-black">{{ $sponsor->heading }}</h3>
	<div class="sponsored">
		<?php  //$exists = Storage::disk(config('app.filesystem_driver'))->exists('public/sponsors/'.$sponsor->image);
				//if($exists){ 
		?>
		<img src="<?php echo asset(Storage::url('public/sponsors/') . $sponsor->image); ?>" alt="" style="max-width:80%" />
		<?php //} 
		?>
		<h3>{{ $sponsor->title }}</h3>
		<a href="#">{{ $sponsor->url }}</a>
	</div>
</div>
</a>
<?php }
		}
?>
</div> --}}



<br />
<br />
<br />
<br />
</div>

<div class="row pt-2 py-3 downloadAppBtn">

	<div class="col-12 mb-3">
		<p class="mb-1 pDownload">Download the app</p>
		<div class="d-flex">
			<div class="mr-1">
				<?php $home_data = Functions::homeInfo();

				if ($home_data->img1 != "") {
					$img1 = asset(Storage::url('public/uploads/' . $home_data->img1));
				} else {
					$img1 = asset('default/google_play.png');
				} ?>
				<a href="<?php echo $home_data->img1_link; ?>" class="google">
					<img src="<?php echo $img1; ?>" alt="" class="img-fluid">
				</a>
			</div>

			<div class="">
				<?php
				if ($home_data->img2 != "") {
					$img2 = asset(Storage::url('public/uploads/' . $home_data->img2));
				} else {
					$img2 = asset('default/app_store.png');
				} ?>
				<a href="<?php echo $home_data->img2_link; ?>" class="apple">
					<img src="<?php echo $img2; ?>" alt="" class="img-fluid">
				</a>
			</div>

		</div>
	</div>

	<div class="col-12">
		<div class="row left-bottom-links">
			<div class="col-xl-12 col-lg-12 col-md-12 video-sm text-left ">
				</hr>
				<?php $links = MyFunctions::getSocialMediaLinks();
				?>
				<ul>
					<li><a href="<?php echo isset($links->fb_link) ? $links->fb_link : '#'; ?>"><i class="fa fa-facebook-official" aria-hidden="true"></i></a></li>
					<li><a href="<?php echo isset($links->twitter_link) ? $links->twitter_link : '#'; ?>"><img src="{{ asset('default/x.svg') }}" width="19px" /></a></li>
					<li><a href="<?php echo isset($links->instagram_link) ? $links->instagram_link : '#'; ?>"><i class="fa fa-instagram" aria-hidden="true"></i></a></li>
					<li><a href="<?php echo isset($links->youtube_link) ? $links->youtube_link : '#'; ?>"><i class="fa fa-youtube-play" aria-hidden="true"></i></a></li>
				</ul>
				<br />
				<a href="{{ url('privacy-policy') }}">Privacy</a> | <a href="{{ url('terms') }}">Terms of Use</a> | <a href="{{ url('data-delete') }}">Data Deletion</a>
				<br />
				<p class="copyright mt-2">&copy {{ date('Y') }} <span class="text-uppercase"><?php echo MyFunctions::getSiteTitle(); ?></span></p>

				<!--<ul class="left-btn">-->
				<!--	<li class="pl-0">- hollywoodwave.ai</li>-->
				<!--	<li class="pl-0">- hollywoodwave.io</li>-->
				<!--	<li class="pl-0">- hollywoodshop.net</li>-->
				<!--	<li class="pl-0">- billiondollaridol.com</li>-->
				<!--	<li class="pl-0">- kidultgo.com</li>-->

				<!--</ul>-->

			</div>
		</div>
	</div>
</div>