<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('settings', 'translation_version')) {
            Schema::table('settings', function (Blueprint $table) {
                $table->string('translation_version', 10)
                    ->nullable()
                    ->after('enable_gift');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('settings', 'translation_version')) {
            Schema::table('settings', function (Blueprint $table) {
                $table->dropColumn('translation_version');
            });
        }
    }
};

