<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Http\Controllers\Controller;
use Hash;
use Auth;
use App\Models\Admin;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Route;
use DateTime;
use DatePeriod;
use DateInterval;
use Illuminate\Support\Facades\Schema;

class ContactUsController extends Controller
{
    public function __construct()
    {
    }

    public function index()
    {
        $contactus = DB::table('contactus')->first();
       

        return view("admin.contact-us", compact('contactus'));
    }

    public function changePassword()
    {
        return view("admin.change_password");
    }

    public function submit(Request $request)
    {

        $rules = [
            'description'      => 'required'
        ];

        $messages = [
            'description.required'         => 'You cant leave description field empty'
        ];


        $this->validate($request, $rules, $messages);
     
        
        if($request->hasFile('image')) {
            $path = 'public/uploads';
            $filenametostore = $request->file('image')->store($path);
            \Storage::setVisibility($filenametostore, 'public');
            $fileArray = explode('/',$filenametostore);
            $image = array_pop($fileArray);
            $data['image'] =  $image;
        }

        
       
        $data['description'] =$request->description;

        // DB::table('contactus')->insert($data);
        $contactExist=DB::table('contactus')->count();
        if($contactExist==0){
            DB::table('contactus')->insert($data);
        }else{
            DB::table('contactus')->where('id',1)->update($data);
        }
       
        return redirect(route('admin.contact-us'))->with('success', 'Contact Us updated successfully');
       
    }
}
